/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWAN router info.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANSendDataToDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANSendDataToDevice.Builder, LoRaWANSendDataToDevice> {
    private static final SdkField<Integer> F_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("FPort")
            .getter(getter(LoRaWANSendDataToDevice::fPort)).setter(setter(Builder::fPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()).build();

    private static final SdkField<ParticipatingGateways> PARTICIPATING_GATEWAYS_FIELD = SdkField
            .<ParticipatingGateways> builder(MarshallingType.SDK_POJO).memberName("ParticipatingGateways")
            .getter(getter(LoRaWANSendDataToDevice::participatingGateways)).setter(setter(Builder::participatingGateways))
            .constructor(ParticipatingGateways::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipatingGateways").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_PORT_FIELD,
            PARTICIPATING_GATEWAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fPort;

    private final ParticipatingGateways participatingGateways;

    private LoRaWANSendDataToDevice(BuilderImpl builder) {
        this.fPort = builder.fPort;
        this.participatingGateways = builder.participatingGateways;
    }

    /**
     * Returns the value of the FPort property for this object.
     * 
     * @return The value of the FPort property for this object.
     */
    public final Integer fPort() {
        return fPort;
    }

    /**
     * <p>
     * Choose the gateways that you want to use for the downlink data traffic when the wireless device is running in
     * class B or class C mode.
     * </p>
     * 
     * @return Choose the gateways that you want to use for the downlink data traffic when the wireless device is
     *         running in class B or class C mode.
     */
    public final ParticipatingGateways participatingGateways() {
        return participatingGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fPort());
        hashCode = 31 * hashCode + Objects.hashCode(participatingGateways());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANSendDataToDevice)) {
            return false;
        }
        LoRaWANSendDataToDevice other = (LoRaWANSendDataToDevice) obj;
        return Objects.equals(fPort(), other.fPort()) && Objects.equals(participatingGateways(), other.participatingGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANSendDataToDevice").add("FPort", fPort())
                .add("ParticipatingGateways", participatingGateways()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FPort":
            return Optional.ofNullable(clazz.cast(fPort()));
        case "ParticipatingGateways":
            return Optional.ofNullable(clazz.cast(participatingGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FPort", F_PORT_FIELD);
        map.put("ParticipatingGateways", PARTICIPATING_GATEWAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANSendDataToDevice, T> g) {
        return obj -> g.apply((LoRaWANSendDataToDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANSendDataToDevice> {
        /**
         * Sets the value of the FPort property for this object.
         *
         * @param fPort
         *        The new value for the FPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fPort(Integer fPort);

        /**
         * <p>
         * Choose the gateways that you want to use for the downlink data traffic when the wireless device is running in
         * class B or class C mode.
         * </p>
         * 
         * @param participatingGateways
         *        Choose the gateways that you want to use for the downlink data traffic when the wireless device is
         *        running in class B or class C mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingGateways(ParticipatingGateways participatingGateways);

        /**
         * <p>
         * Choose the gateways that you want to use for the downlink data traffic when the wireless device is running in
         * class B or class C mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipatingGateways.Builder} avoiding
         * the need to create one manually via {@link ParticipatingGateways#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipatingGateways.Builder#build()} is called immediately and
         * its result is passed to {@link #participatingGateways(ParticipatingGateways)}.
         * 
         * @param participatingGateways
         *        a consumer that will call methods on {@link ParticipatingGateways.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participatingGateways(ParticipatingGateways)
         */
        default Builder participatingGateways(Consumer<ParticipatingGateways.Builder> participatingGateways) {
            return participatingGateways(ParticipatingGateways.builder().applyMutation(participatingGateways).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer fPort;

        private ParticipatingGateways participatingGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANSendDataToDevice model) {
            fPort(model.fPort);
            participatingGateways(model.participatingGateways);
        }

        public final Integer getFPort() {
            return fPort;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        @Override
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        public final ParticipatingGateways.Builder getParticipatingGateways() {
            return participatingGateways != null ? participatingGateways.toBuilder() : null;
        }

        public final void setParticipatingGateways(ParticipatingGateways.BuilderImpl participatingGateways) {
            this.participatingGateways = participatingGateways != null ? participatingGateways.build() : null;
        }

        @Override
        public final Builder participatingGateways(ParticipatingGateways participatingGateways) {
            this.participatingGateways = participatingGateways;
            return this;
        }

        @Override
        public LoRaWANSendDataToDevice build() {
            return new LoRaWANSendDataToDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
