/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OTAA device object for v1.1
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaaV1_1 implements SdkPojo, Serializable, ToCopyableBuilder<OtaaV1_1.Builder, OtaaV1_1> {
    private static final SdkField<String> APP_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppKey")
            .getter(getter(OtaaV1_1::appKey)).setter(setter(Builder::appKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppKey").build()).build();

    private static final SdkField<String> NWK_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NwkKey")
            .getter(getter(OtaaV1_1::nwkKey)).setter(setter(Builder::nwkKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NwkKey").build()).build();

    private static final SdkField<String> JOIN_EUI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinEui").getter(getter(OtaaV1_1::joinEui)).setter(setter(Builder::joinEui))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEui").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_KEY_FIELD, NWK_KEY_FIELD,
            JOIN_EUI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String appKey;

    private final String nwkKey;

    private final String joinEui;

    private OtaaV1_1(BuilderImpl builder) {
        this.appKey = builder.appKey;
        this.nwkKey = builder.nwkKey;
        this.joinEui = builder.joinEui;
    }

    /**
     * <p>
     * The AppKey value.
     * </p>
     * 
     * @return The AppKey value.
     */
    public final String appKey() {
        return appKey;
    }

    /**
     * <p>
     * The NwkKey value.
     * </p>
     * 
     * @return The NwkKey value.
     */
    public final String nwkKey() {
        return nwkKey;
    }

    /**
     * <p>
     * The JoinEUI value.
     * </p>
     * 
     * @return The JoinEUI value.
     */
    public final String joinEui() {
        return joinEui;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appKey());
        hashCode = 31 * hashCode + Objects.hashCode(nwkKey());
        hashCode = 31 * hashCode + Objects.hashCode(joinEui());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaaV1_1)) {
            return false;
        }
        OtaaV1_1 other = (OtaaV1_1) obj;
        return Objects.equals(appKey(), other.appKey()) && Objects.equals(nwkKey(), other.nwkKey())
                && Objects.equals(joinEui(), other.joinEui());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaaV1_1").add("AppKey", appKey()).add("NwkKey", nwkKey()).add("JoinEui", joinEui()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppKey":
            return Optional.ofNullable(clazz.cast(appKey()));
        case "NwkKey":
            return Optional.ofNullable(clazz.cast(nwkKey()));
        case "JoinEui":
            return Optional.ofNullable(clazz.cast(joinEui()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppKey", APP_KEY_FIELD);
        map.put("NwkKey", NWK_KEY_FIELD);
        map.put("JoinEui", JOIN_EUI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaaV1_1, T> g) {
        return obj -> g.apply((OtaaV1_1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaaV1_1> {
        /**
         * <p>
         * The AppKey value.
         * </p>
         * 
         * @param appKey
         *        The AppKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appKey(String appKey);

        /**
         * <p>
         * The NwkKey value.
         * </p>
         * 
         * @param nwkKey
         *        The NwkKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nwkKey(String nwkKey);

        /**
         * <p>
         * The JoinEUI value.
         * </p>
         * 
         * @param joinEui
         *        The JoinEUI value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinEui(String joinEui);
    }

    static final class BuilderImpl implements Builder {
        private String appKey;

        private String nwkKey;

        private String joinEui;

        private BuilderImpl() {
        }

        private BuilderImpl(OtaaV1_1 model) {
            appKey(model.appKey);
            nwkKey(model.nwkKey);
            joinEui(model.joinEui);
        }

        public final String getAppKey() {
            return appKey;
        }

        public final void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        @Override
        public final Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public final String getNwkKey() {
            return nwkKey;
        }

        public final void setNwkKey(String nwkKey) {
            this.nwkKey = nwkKey;
        }

        @Override
        public final Builder nwkKey(String nwkKey) {
            this.nwkKey = nwkKey;
            return this;
        }

        public final String getJoinEui() {
            return joinEui;
        }

        public final void setJoinEui(String joinEui) {
            this.joinEui = joinEui;
        }

        @Override
        public final Builder joinEui(String joinEui) {
            this.joinEui = joinEui;
            return this;
        }

        @Override
        public OtaaV1_1 build() {
            return new OtaaV1_1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
