/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sidewalk object for creating a wireless device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkCreateWirelessDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkCreateWirelessDevice.Builder, SidewalkCreateWirelessDevice> {
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(SidewalkCreateWirelessDevice::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()).build();

    private static final SdkField<SidewalkPositioning> POSITIONING_FIELD = SdkField
            .<SidewalkPositioning> builder(MarshallingType.SDK_POJO).memberName("Positioning")
            .getter(getter(SidewalkCreateWirelessDevice::positioning)).setter(setter(Builder::positioning))
            .constructor(SidewalkPositioning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkManufacturingSn").getter(getter(SidewalkCreateWirelessDevice::sidewalkManufacturingSn))
            .setter(setter(Builder::sidewalkManufacturingSn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_PROFILE_ID_FIELD,
            POSITIONING_FIELD, SIDEWALK_MANUFACTURING_SN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceProfileId;

    private final SidewalkPositioning positioning;

    private final String sidewalkManufacturingSn;

    private SidewalkCreateWirelessDevice(BuilderImpl builder) {
        this.deviceProfileId = builder.deviceProfileId;
        this.positioning = builder.positioning;
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
    }

    /**
     * <p>
     * The ID of the Sidewalk device profile.
     * </p>
     * 
     * @return The ID of the Sidewalk device profile.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * The Positioning object of the Sidewalk device.
     * </p>
     * 
     * @return The Positioning object of the Sidewalk device.
     */
    public final SidewalkPositioning positioning() {
        return positioning;
    }

    /**
     * <p>
     * The Sidewalk manufacturing serial number.
     * </p>
     * 
     * @return The Sidewalk manufacturing serial number.
     */
    public final String sidewalkManufacturingSn() {
        return sidewalkManufacturingSn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(positioning());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkManufacturingSn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkCreateWirelessDevice)) {
            return false;
        }
        SidewalkCreateWirelessDevice other = (SidewalkCreateWirelessDevice) obj;
        return Objects.equals(deviceProfileId(), other.deviceProfileId()) && Objects.equals(positioning(), other.positioning())
                && Objects.equals(sidewalkManufacturingSn(), other.sidewalkManufacturingSn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkCreateWirelessDevice").add("DeviceProfileId", deviceProfileId())
                .add("Positioning", positioning()).add("SidewalkManufacturingSn", sidewalkManufacturingSn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioning()));
        case "SidewalkManufacturingSn":
            return Optional.ofNullable(clazz.cast(sidewalkManufacturingSn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceProfileId", DEVICE_PROFILE_ID_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        map.put("SidewalkManufacturingSn", SIDEWALK_MANUFACTURING_SN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkCreateWirelessDevice, T> g) {
        return obj -> g.apply((SidewalkCreateWirelessDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkCreateWirelessDevice> {
        /**
         * <p>
         * The ID of the Sidewalk device profile.
         * </p>
         * 
         * @param deviceProfileId
         *        The ID of the Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * 
         * @param positioning
         *        The Positioning object of the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positioning(SidewalkPositioning positioning);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkPositioning.Builder} avoiding the
         * need to create one manually via {@link SidewalkPositioning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkPositioning.Builder#build()} is called immediately and
         * its result is passed to {@link #positioning(SidewalkPositioning)}.
         * 
         * @param positioning
         *        a consumer that will call methods on {@link SidewalkPositioning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positioning(SidewalkPositioning)
         */
        default Builder positioning(Consumer<SidewalkPositioning.Builder> positioning) {
            return positioning(SidewalkPositioning.builder().applyMutation(positioning).build());
        }

        /**
         * <p>
         * The Sidewalk manufacturing serial number.
         * </p>
         * 
         * @param sidewalkManufacturingSn
         *        The Sidewalk manufacturing serial number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkManufacturingSn(String sidewalkManufacturingSn);
    }

    static final class BuilderImpl implements Builder {
        private String deviceProfileId;

        private SidewalkPositioning positioning;

        private String sidewalkManufacturingSn;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkCreateWirelessDevice model) {
            deviceProfileId(model.deviceProfileId);
            positioning(model.positioning);
            sidewalkManufacturingSn(model.sidewalkManufacturingSn);
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final SidewalkPositioning.Builder getPositioning() {
            return positioning != null ? positioning.toBuilder() : null;
        }

        public final void setPositioning(SidewalkPositioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(SidewalkPositioning positioning) {
            this.positioning = positioning;
            return this;
        }

        public final String getSidewalkManufacturingSn() {
            return sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        @Override
        public SidewalkCreateWirelessDevice build() {
            return new SidewalkCreateWirelessDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
