/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sidewalk device object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkDevice implements SdkPojo, Serializable, ToCopyableBuilder<SidewalkDevice.Builder, SidewalkDevice> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonId").getter(getter(SidewalkDevice::amazonId)).setter(setter(Builder::amazonId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()).build();

    private static final SdkField<String> SIDEWALK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkId").getter(getter(SidewalkDevice::sidewalkId)).setter(setter(Builder::sidewalkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkId").build()).build();

    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkManufacturingSn").getter(getter(SidewalkDevice::sidewalkManufacturingSn))
            .setter(setter(Builder::sidewalkManufacturingSn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build())
            .build();

    private static final SdkField<List<CertificateList>> DEVICE_CERTIFICATES_FIELD = SdkField
            .<List<CertificateList>> builder(MarshallingType.LIST)
            .memberName("DeviceCertificates")
            .getter(getter(SidewalkDevice::deviceCertificates))
            .setter(setter(Builder::deviceCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateList> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CertificateList>> PRIVATE_KEYS_FIELD = SdkField
            .<List<CertificateList>> builder(MarshallingType.LIST)
            .memberName("PrivateKeys")
            .getter(getter(SidewalkDevice::privateKeys))
            .setter(setter(Builder::privateKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateList> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileId").getter(getter(SidewalkDevice::deviceProfileId))
            .setter(setter(Builder::deviceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(SidewalkDevice::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SidewalkDevice::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<SidewalkPositioning> POSITIONING_FIELD = SdkField
            .<SidewalkPositioning> builder(MarshallingType.SDK_POJO).memberName("Positioning")
            .getter(getter(SidewalkDevice::positioning)).setter(setter(Builder::positioning))
            .constructor(SidewalkPositioning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD,
            SIDEWALK_ID_FIELD, SIDEWALK_MANUFACTURING_SN_FIELD, DEVICE_CERTIFICATES_FIELD, PRIVATE_KEYS_FIELD,
            DEVICE_PROFILE_ID_FIELD, CERTIFICATE_ID_FIELD, STATUS_FIELD, POSITIONING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amazonId;

    private final String sidewalkId;

    private final String sidewalkManufacturingSn;

    private final List<CertificateList> deviceCertificates;

    private final List<CertificateList> privateKeys;

    private final String deviceProfileId;

    private final String certificateId;

    private final String status;

    private final SidewalkPositioning positioning;

    private SidewalkDevice(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.sidewalkId = builder.sidewalkId;
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.deviceCertificates = builder.deviceCertificates;
        this.privateKeys = builder.privateKeys;
        this.deviceProfileId = builder.deviceProfileId;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.positioning = builder.positioning;
    }

    /**
     * Returns the value of the AmazonId property for this object.
     * 
     * @return The value of the AmazonId property for this object.
     */
    public final String amazonId() {
        return amazonId;
    }

    /**
     * <p>
     * The sidewalk device identification.
     * </p>
     * 
     * @return The sidewalk device identification.
     */
    public final String sidewalkId() {
        return sidewalkId;
    }

    /**
     * <p>
     * The Sidewalk manufacturing series number.
     * </p>
     * 
     * @return The Sidewalk manufacturing series number.
     */
    public final String sidewalkManufacturingSn() {
        return sidewalkManufacturingSn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceCertificates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceCertificates() {
        return deviceCertificates != null && !(deviceCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sidewalk device certificates for Ed25519 and P256r1.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceCertificates} method.
     * </p>
     * 
     * @return The sidewalk device certificates for Ed25519 and P256r1.
     */
    public final List<CertificateList> deviceCertificates() {
        return deviceCertificates;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateKeys() {
        return privateKeys != null && !(privateKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Sidewalk device private keys that will be used for onboarding the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateKeys} method.
     * </p>
     * 
     * @return The Sidewalk device private keys that will be used for onboarding the device.
     */
    public final List<CertificateList> privateKeys() {
        return privateKeys;
    }

    /**
     * <p>
     * The ID of the Sidewalk device profile.
     * </p>
     * 
     * @return The ID of the Sidewalk device profile.
     */
    public final String deviceProfileId() {
        return deviceProfileId;
    }

    /**
     * <p>
     * The ID of the Sidewalk device profile.
     * </p>
     * 
     * @return The ID of the Sidewalk device profile.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The Sidewalk device status, such as provisioned or registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessDeviceSidewalkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The Sidewalk device status, such as provisioned or registered.
     * @see WirelessDeviceSidewalkStatus
     */
    public final WirelessDeviceSidewalkStatus status() {
        return WirelessDeviceSidewalkStatus.fromValue(status);
    }

    /**
     * <p>
     * The Sidewalk device status, such as provisioned or registered.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WirelessDeviceSidewalkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The Sidewalk device status, such as provisioned or registered.
     * @see WirelessDeviceSidewalkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Positioning object of the Sidewalk device.
     * </p>
     * 
     * @return The Positioning object of the Sidewalk device.
     */
    public final SidewalkPositioning positioning() {
        return positioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkId());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceCertificates() ? deviceCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateKeys() ? privateKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(positioning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkDevice)) {
            return false;
        }
        SidewalkDevice other = (SidewalkDevice) obj;
        return Objects.equals(amazonId(), other.amazonId()) && Objects.equals(sidewalkId(), other.sidewalkId())
                && Objects.equals(sidewalkManufacturingSn(), other.sidewalkManufacturingSn())
                && hasDeviceCertificates() == other.hasDeviceCertificates()
                && Objects.equals(deviceCertificates(), other.deviceCertificates()) && hasPrivateKeys() == other.hasPrivateKeys()
                && Objects.equals(privateKeys(), other.privateKeys())
                && Objects.equals(deviceProfileId(), other.deviceProfileId())
                && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(positioning(), other.positioning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkDevice").add("AmazonId", amazonId()).add("SidewalkId", sidewalkId())
                .add("SidewalkManufacturingSn", sidewalkManufacturingSn())
                .add("DeviceCertificates", hasDeviceCertificates() ? deviceCertificates() : null)
                .add("PrivateKeys", hasPrivateKeys() ? privateKeys() : null).add("DeviceProfileId", deviceProfileId())
                .add("CertificateId", certificateId()).add("Status", statusAsString()).add("Positioning", positioning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonId":
            return Optional.ofNullable(clazz.cast(amazonId()));
        case "SidewalkId":
            return Optional.ofNullable(clazz.cast(sidewalkId()));
        case "SidewalkManufacturingSn":
            return Optional.ofNullable(clazz.cast(sidewalkManufacturingSn()));
        case "DeviceCertificates":
            return Optional.ofNullable(clazz.cast(deviceCertificates()));
        case "PrivateKeys":
            return Optional.ofNullable(clazz.cast(privateKeys()));
        case "DeviceProfileId":
            return Optional.ofNullable(clazz.cast(deviceProfileId()));
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AmazonId", AMAZON_ID_FIELD);
        map.put("SidewalkId", SIDEWALK_ID_FIELD);
        map.put("SidewalkManufacturingSn", SIDEWALK_MANUFACTURING_SN_FIELD);
        map.put("DeviceCertificates", DEVICE_CERTIFICATES_FIELD);
        map.put("PrivateKeys", PRIVATE_KEYS_FIELD);
        map.put("DeviceProfileId", DEVICE_PROFILE_ID_FIELD);
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkDevice, T> g) {
        return obj -> g.apply((SidewalkDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkDevice> {
        /**
         * Sets the value of the AmazonId property for this object.
         *
         * @param amazonId
         *        The new value for the AmazonId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonId(String amazonId);

        /**
         * <p>
         * The sidewalk device identification.
         * </p>
         * 
         * @param sidewalkId
         *        The sidewalk device identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkId(String sidewalkId);

        /**
         * <p>
         * The Sidewalk manufacturing series number.
         * </p>
         * 
         * @param sidewalkManufacturingSn
         *        The Sidewalk manufacturing series number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkManufacturingSn(String sidewalkManufacturingSn);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * 
         * @param deviceCertificates
         *        The sidewalk device certificates for Ed25519 and P256r1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificates(Collection<CertificateList> deviceCertificates);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * 
         * @param deviceCertificates
         *        The sidewalk device certificates for Ed25519 and P256r1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificates(CertificateList... deviceCertificates);

        /**
         * <p>
         * The sidewalk device certificates for Ed25519 and P256r1.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.CertificateList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceCertificates(List<CertificateList>)}.
         * 
         * @param deviceCertificates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceCertificates(java.util.Collection<CertificateList>)
         */
        Builder deviceCertificates(Consumer<CertificateList.Builder>... deviceCertificates);

        /**
         * <p>
         * The Sidewalk device private keys that will be used for onboarding the device.
         * </p>
         * 
         * @param privateKeys
         *        The Sidewalk device private keys that will be used for onboarding the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeys(Collection<CertificateList> privateKeys);

        /**
         * <p>
         * The Sidewalk device private keys that will be used for onboarding the device.
         * </p>
         * 
         * @param privateKeys
         *        The Sidewalk device private keys that will be used for onboarding the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeys(CertificateList... privateKeys);

        /**
         * <p>
         * The Sidewalk device private keys that will be used for onboarding the device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotwireless.model.CertificateList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder#build()} is called
         * immediately and its result is passed to {@link #privateKeys(List<CertificateList>)}.
         * 
         * @param privateKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.CertificateList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeys(java.util.Collection<CertificateList>)
         */
        Builder privateKeys(Consumer<CertificateList.Builder>... privateKeys);

        /**
         * <p>
         * The ID of the Sidewalk device profile.
         * </p>
         * 
         * @param deviceProfileId
         *        The ID of the Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProfileId(String deviceProfileId);

        /**
         * <p>
         * The ID of the Sidewalk device profile.
         * </p>
         * 
         * @param certificateId
         *        The ID of the Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The Sidewalk device status, such as provisioned or registered.
         * </p>
         * 
         * @param status
         *        The Sidewalk device status, such as provisioned or registered.
         * @see WirelessDeviceSidewalkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceSidewalkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The Sidewalk device status, such as provisioned or registered.
         * </p>
         * 
         * @param status
         *        The Sidewalk device status, such as provisioned or registered.
         * @see WirelessDeviceSidewalkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceSidewalkStatus
         */
        Builder status(WirelessDeviceSidewalkStatus status);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * 
         * @param positioning
         *        The Positioning object of the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positioning(SidewalkPositioning positioning);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkPositioning.Builder} avoiding the
         * need to create one manually via {@link SidewalkPositioning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkPositioning.Builder#build()} is called immediately and
         * its result is passed to {@link #positioning(SidewalkPositioning)}.
         * 
         * @param positioning
         *        a consumer that will call methods on {@link SidewalkPositioning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positioning(SidewalkPositioning)
         */
        default Builder positioning(Consumer<SidewalkPositioning.Builder> positioning) {
            return positioning(SidewalkPositioning.builder().applyMutation(positioning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String amazonId;

        private String sidewalkId;

        private String sidewalkManufacturingSn;

        private List<CertificateList> deviceCertificates = DefaultSdkAutoConstructList.getInstance();

        private List<CertificateList> privateKeys = DefaultSdkAutoConstructList.getInstance();

        private String deviceProfileId;

        private String certificateId;

        private String status;

        private SidewalkPositioning positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkDevice model) {
            amazonId(model.amazonId);
            sidewalkId(model.sidewalkId);
            sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            deviceCertificates(model.deviceCertificates);
            privateKeys(model.privateKeys);
            deviceProfileId(model.deviceProfileId);
            certificateId(model.certificateId);
            status(model.status);
            positioning(model.positioning);
        }

        public final String getAmazonId() {
            return amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getSidewalkId() {
            return sidewalkId;
        }

        public final void setSidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
        }

        @Override
        public final Builder sidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
            return this;
        }

        public final String getSidewalkManufacturingSn() {
            return sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final List<CertificateList.Builder> getDeviceCertificates() {
            List<CertificateList.Builder> result = DeviceCertificateListCopier.copyToBuilder(this.deviceCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCertificates(Collection<CertificateList.BuilderImpl> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copyFromBuilder(deviceCertificates);
        }

        @Override
        public final Builder deviceCertificates(Collection<CertificateList> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copy(deviceCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(CertificateList... deviceCertificates) {
            deviceCertificates(Arrays.asList(deviceCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(Consumer<CertificateList.Builder>... deviceCertificates) {
            deviceCertificates(Stream.of(deviceCertificates).map(c -> CertificateList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CertificateList.Builder> getPrivateKeys() {
            List<CertificateList.Builder> result = PrivateKeysListCopier.copyToBuilder(this.privateKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateKeys(Collection<CertificateList.BuilderImpl> privateKeys) {
            this.privateKeys = PrivateKeysListCopier.copyFromBuilder(privateKeys);
        }

        @Override
        public final Builder privateKeys(Collection<CertificateList> privateKeys) {
            this.privateKeys = PrivateKeysListCopier.copy(privateKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateKeys(CertificateList... privateKeys) {
            privateKeys(Arrays.asList(privateKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateKeys(Consumer<CertificateList.Builder>... privateKeys) {
            privateKeys(Stream.of(privateKeys).map(c -> CertificateList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceProfileId() {
            return deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WirelessDeviceSidewalkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SidewalkPositioning.Builder getPositioning() {
            return positioning != null ? positioning.toBuilder() : null;
        }

        public final void setPositioning(SidewalkPositioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(SidewalkPositioning positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public SidewalkDevice build() {
            return new SidewalkDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
