/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Sidewalk-related object containing positioning information used to configure Sidewalk devices during import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkListDevicesForImportInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkListDevicesForImportInfo.Builder, SidewalkListDevicesForImportInfo> {
    private static final SdkField<SidewalkPositioning> POSITIONING_FIELD = SdkField
            .<SidewalkPositioning> builder(MarshallingType.SDK_POJO).memberName("Positioning")
            .getter(getter(SidewalkListDevicesForImportInfo::positioning)).setter(setter(Builder::positioning))
            .constructor(SidewalkPositioning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITIONING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SidewalkPositioning positioning;

    private SidewalkListDevicesForImportInfo(BuilderImpl builder) {
        this.positioning = builder.positioning;
    }

    /**
     * <p>
     * The Positioning object of the Sidewalk device.
     * </p>
     * 
     * @return The Positioning object of the Sidewalk device.
     */
    public final SidewalkPositioning positioning() {
        return positioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(positioning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkListDevicesForImportInfo)) {
            return false;
        }
        SidewalkListDevicesForImportInfo other = (SidewalkListDevicesForImportInfo) obj;
        return Objects.equals(positioning(), other.positioning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkListDevicesForImportInfo").add("Positioning", positioning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Positioning", POSITIONING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkListDevicesForImportInfo, T> g) {
        return obj -> g.apply((SidewalkListDevicesForImportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkListDevicesForImportInfo> {
        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * 
         * @param positioning
         *        The Positioning object of the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positioning(SidewalkPositioning positioning);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkPositioning.Builder} avoiding the
         * need to create one manually via {@link SidewalkPositioning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkPositioning.Builder#build()} is called immediately and
         * its result is passed to {@link #positioning(SidewalkPositioning)}.
         * 
         * @param positioning
         *        a consumer that will call methods on {@link SidewalkPositioning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positioning(SidewalkPositioning)
         */
        default Builder positioning(Consumer<SidewalkPositioning.Builder> positioning) {
            return positioning(SidewalkPositioning.builder().applyMutation(positioning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SidewalkPositioning positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkListDevicesForImportInfo model) {
            positioning(model.positioning);
        }

        public final SidewalkPositioning.Builder getPositioning() {
            return positioning != null ? positioning.toBuilder() : null;
        }

        public final void setPositioning(SidewalkPositioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(SidewalkPositioning positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public SidewalkListDevicesForImportInfo build() {
            return new SidewalkListDevicesForImportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
