/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an import task created for an individual Sidewalk device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkSingleStartImportInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkSingleStartImportInfo.Builder, SidewalkSingleStartImportInfo> {
    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SidewalkManufacturingSn").getter(getter(SidewalkSingleStartImportInfo::sidewalkManufacturingSn))
            .setter(setter(Builder::sidewalkManufacturingSn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build())
            .build();

    private static final SdkField<SidewalkPositioning> POSITIONING_FIELD = SdkField
            .<SidewalkPositioning> builder(MarshallingType.SDK_POJO).memberName("Positioning")
            .getter(getter(SidewalkSingleStartImportInfo::positioning)).setter(setter(Builder::positioning))
            .constructor(SidewalkPositioning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIDEWALK_MANUFACTURING_SN_FIELD, POSITIONING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sidewalkManufacturingSn;

    private final SidewalkPositioning positioning;

    private SidewalkSingleStartImportInfo(BuilderImpl builder) {
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.positioning = builder.positioning;
    }

    /**
     * <p>
     * The Sidewalk manufacturing serial number (SMSN) of the device added to the import task.
     * </p>
     * 
     * @return The Sidewalk manufacturing serial number (SMSN) of the device added to the import task.
     */
    public final String sidewalkManufacturingSn() {
        return sidewalkManufacturingSn;
    }

    /**
     * <p>
     * The Positioning object of the Sidewalk device.
     * </p>
     * 
     * @return The Positioning object of the Sidewalk device.
     */
    public final SidewalkPositioning positioning() {
        return positioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(positioning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkSingleStartImportInfo)) {
            return false;
        }
        SidewalkSingleStartImportInfo other = (SidewalkSingleStartImportInfo) obj;
        return Objects.equals(sidewalkManufacturingSn(), other.sidewalkManufacturingSn())
                && Objects.equals(positioning(), other.positioning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkSingleStartImportInfo").add("SidewalkManufacturingSn", sidewalkManufacturingSn())
                .add("Positioning", positioning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SidewalkManufacturingSn":
            return Optional.ofNullable(clazz.cast(sidewalkManufacturingSn()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SidewalkManufacturingSn", SIDEWALK_MANUFACTURING_SN_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkSingleStartImportInfo, T> g) {
        return obj -> g.apply((SidewalkSingleStartImportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkSingleStartImportInfo> {
        /**
         * <p>
         * The Sidewalk manufacturing serial number (SMSN) of the device added to the import task.
         * </p>
         * 
         * @param sidewalkManufacturingSn
         *        The Sidewalk manufacturing serial number (SMSN) of the device added to the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalkManufacturingSn(String sidewalkManufacturingSn);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * 
         * @param positioning
         *        The Positioning object of the Sidewalk device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positioning(SidewalkPositioning positioning);

        /**
         * <p>
         * The Positioning object of the Sidewalk device.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkPositioning.Builder} avoiding the
         * need to create one manually via {@link SidewalkPositioning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkPositioning.Builder#build()} is called immediately and
         * its result is passed to {@link #positioning(SidewalkPositioning)}.
         * 
         * @param positioning
         *        a consumer that will call methods on {@link SidewalkPositioning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #positioning(SidewalkPositioning)
         */
        default Builder positioning(Consumer<SidewalkPositioning.Builder> positioning) {
            return positioning(SidewalkPositioning.builder().applyMutation(positioning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sidewalkManufacturingSn;

        private SidewalkPositioning positioning;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkSingleStartImportInfo model) {
            sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            positioning(model.positioning);
        }

        public final String getSidewalkManufacturingSn() {
            return sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final SidewalkPositioning.Builder getPositioning() {
            return positioning != null ? positioning.toBuilder() : null;
        }

        public final void setPositioning(SidewalkPositioning.BuilderImpl positioning) {
            this.positioning = positioning != null ? positioning.build() : null;
        }

        @Override
        public final Builder positioning(SidewalkPositioning positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public SidewalkSingleStartImportInfo build() {
            return new SidewalkSingleStartImportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
