/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sidewalk object information for updating an import task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkUpdateImportInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkUpdateImportInfo.Builder, SidewalkUpdateImportInfo> {
    private static final SdkField<String> DEVICE_CREATION_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceCreationFile").getter(getter(SidewalkUpdateImportInfo::deviceCreationFile))
            .setter(setter(Builder::deviceCreationFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCreationFile").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CREATION_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceCreationFile;

    private SidewalkUpdateImportInfo(BuilderImpl builder) {
        this.deviceCreationFile = builder.deviceCreationFile;
    }

    /**
     * <p>
     * The CSV file contained in an S3 bucket that's used for appending devices to an existing import task.
     * </p>
     * 
     * @return The CSV file contained in an S3 bucket that's used for appending devices to an existing import task.
     */
    public final String deviceCreationFile() {
        return deviceCreationFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceCreationFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkUpdateImportInfo)) {
            return false;
        }
        SidewalkUpdateImportInfo other = (SidewalkUpdateImportInfo) obj;
        return Objects.equals(deviceCreationFile(), other.deviceCreationFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SidewalkUpdateImportInfo").add("DeviceCreationFile", deviceCreationFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceCreationFile":
            return Optional.ofNullable(clazz.cast(deviceCreationFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceCreationFile", DEVICE_CREATION_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SidewalkUpdateImportInfo, T> g) {
        return obj -> g.apply((SidewalkUpdateImportInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkUpdateImportInfo> {
        /**
         * <p>
         * The CSV file contained in an S3 bucket that's used for appending devices to an existing import task.
         * </p>
         * 
         * @param deviceCreationFile
         *        The CSV file contained in an S3 bucket that's used for appending devices to an existing import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreationFile(String deviceCreationFile);
    }

    static final class BuilderImpl implements Builder {
        private String deviceCreationFile;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkUpdateImportInfo model) {
            deviceCreationFile(model.deviceCreationFile);
        }

        public final String getDeviceCreationFile() {
            return deviceCreationFile;
        }

        public final void setDeviceCreationFile(String deviceCreationFile) {
            this.deviceCreationFile = deviceCreationFile;
        }

        @Override
        public final Builder deviceCreationFile(String deviceCreationFile) {
            this.deviceCreationFile = deviceCreationFile;
            return this;
        }

        @Override
        public SidewalkUpdateImportInfo build() {
            return new SidewalkUpdateImportInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
