/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWirelessDeviceImportTaskRequest extends IotWirelessRequest implements
        ToCopyableBuilder<StartWirelessDeviceImportTaskRequest.Builder, StartWirelessDeviceImportTaskRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(StartWirelessDeviceImportTaskRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(StartWirelessDeviceImportTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartWirelessDeviceImportTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POSITIONING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Positioning").getter(getter(StartWirelessDeviceImportTaskRequest::positioningAsString))
            .setter(setter(Builder::positioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positioning").build()).build();

    private static final SdkField<SidewalkStartImportInfo> SIDEWALK_FIELD = SdkField
            .<SidewalkStartImportInfo> builder(MarshallingType.SDK_POJO).memberName("Sidewalk")
            .getter(getter(StartWirelessDeviceImportTaskRequest::sidewalk)).setter(setter(Builder::sidewalk))
            .constructor(SidewalkStartImportInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, POSITIONING_FIELD, SIDEWALK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationName;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private final String positioning;

    private final SidewalkStartImportInfo sidewalk;

    private StartWirelessDeviceImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.positioning = builder.positioning;
        this.sidewalk = builder.sidewalk;
    }

    /**
     * <p>
     * The name of the Sidewalk destination that describes the IoT rule to route messages from the devices in the import
     * task that are onboarded to AWS IoT Wireless.
     * </p>
     * 
     * @return The name of the Sidewalk destination that describes the IoT rule to route messages from the devices in
     *         the import task that are onboarded to AWS IoT Wireless.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The integration status of the Device Location feature for Sidewalk devices.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positioning} will
     * return {@link PositioningConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positioningAsString}.
     * </p>
     * 
     * @return The integration status of the Device Location feature for Sidewalk devices.
     * @see PositioningConfigStatus
     */
    public final PositioningConfigStatus positioning() {
        return PositioningConfigStatus.fromValue(positioning);
    }

    /**
     * <p>
     * The integration status of the Device Location feature for Sidewalk devices.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #positioning} will
     * return {@link PositioningConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #positioningAsString}.
     * </p>
     * 
     * @return The integration status of the Device Location feature for Sidewalk devices.
     * @see PositioningConfigStatus
     */
    public final String positioningAsString() {
        return positioning;
    }

    /**
     * <p>
     * The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.
     * </p>
     * 
     * @return The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.
     */
    public final SidewalkStartImportInfo sidewalk() {
        return sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(positioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sidewalk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWirelessDeviceImportTaskRequest)) {
            return false;
        }
        StartWirelessDeviceImportTaskRequest other = (StartWirelessDeviceImportTaskRequest) obj;
        return Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(positioningAsString(), other.positioningAsString())
                && Objects.equals(sidewalk(), other.sidewalk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWirelessDeviceImportTaskRequest").add("DestinationName", destinationName())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", hasTags() ? tags() : null)
                .add("Positioning", positioningAsString()).add("Sidewalk", sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Positioning":
            return Optional.ofNullable(clazz.cast(positioningAsString()));
        case "Sidewalk":
            return Optional.ofNullable(clazz.cast(sidewalk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Positioning", POSITIONING_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWirelessDeviceImportTaskRequest, T> g) {
        return obj -> g.apply((StartWirelessDeviceImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartWirelessDeviceImportTaskRequest> {
        /**
         * <p>
         * The name of the Sidewalk destination that describes the IoT rule to route messages from the devices in the
         * import task that are onboarded to AWS IoT Wireless.
         * </p>
         * 
         * @param destinationName
         *        The name of the Sidewalk destination that describes the IoT rule to route messages from the devices in
         *        the import task that are onboarded to AWS IoT Wireless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The integration status of the Device Location feature for Sidewalk devices.
         * </p>
         * 
         * @param positioning
         *        The integration status of the Device Location feature for Sidewalk devices.
         * @see PositioningConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositioningConfigStatus
         */
        Builder positioning(String positioning);

        /**
         * <p>
         * The integration status of the Device Location feature for Sidewalk devices.
         * </p>
         * 
         * @param positioning
         *        The integration status of the Device Location feature for Sidewalk devices.
         * @see PositioningConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositioningConfigStatus
         */
        Builder positioning(PositioningConfigStatus positioning);

        /**
         * <p>
         * The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.
         * </p>
         * 
         * @param sidewalk
         *        The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sidewalk(SidewalkStartImportInfo sidewalk);

        /**
         * <p>
         * The Sidewalk-related parameters for importing wireless devices that need to be provisioned in bulk.
         * </p>
         * This is a convenience method that creates an instance of the {@link SidewalkStartImportInfo.Builder} avoiding
         * the need to create one manually via {@link SidewalkStartImportInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SidewalkStartImportInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #sidewalk(SidewalkStartImportInfo)}.
         * 
         * @param sidewalk
         *        a consumer that will call methods on {@link SidewalkStartImportInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sidewalk(SidewalkStartImportInfo)
         */
        default Builder sidewalk(Consumer<SidewalkStartImportInfo.Builder> sidewalk) {
            return sidewalk(SidewalkStartImportInfo.builder().applyMutation(sidewalk).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String destinationName;

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String positioning;

        private SidewalkStartImportInfo sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWirelessDeviceImportTaskRequest model) {
            super(model);
            destinationName(model.destinationName);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
            positioning(model.positioning);
            sidewalk(model.sidewalk);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPositioning() {
            return positioning;
        }

        public final void setPositioning(String positioning) {
            this.positioning = positioning;
        }

        @Override
        public final Builder positioning(String positioning) {
            this.positioning = positioning;
            return this;
        }

        @Override
        public final Builder positioning(PositioningConfigStatus positioning) {
            this.positioning(positioning == null ? null : positioning.toString());
            return this;
        }

        public final SidewalkStartImportInfo.Builder getSidewalk() {
            return sidewalk != null ? sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkStartImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkStartImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWirelessDeviceImportTaskRequest build() {
            return new StartWirelessDeviceImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
