/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TD-SCDMA local identification (local Id) information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TdscdmaLocalId implements SdkPojo, Serializable, ToCopyableBuilder<TdscdmaLocalId.Builder, TdscdmaLocalId> {
    private static final SdkField<Integer> UARFCN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Uarfcn").getter(getter(TdscdmaLocalId::uarfcn)).setter(setter(Builder::uarfcn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uarfcn").build()).build();

    private static final SdkField<Integer> CELL_PARAMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CellParams").getter(getter(TdscdmaLocalId::cellParams)).setter(setter(Builder::cellParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellParams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UARFCN_FIELD,
            CELL_PARAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer uarfcn;

    private final Integer cellParams;

    private TdscdmaLocalId(BuilderImpl builder) {
        this.uarfcn = builder.uarfcn;
        this.cellParams = builder.cellParams;
    }

    /**
     * <p>
     * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number (UARFCN).
     * </p>
     * 
     * @return TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number (UARFCN).
     */
    public final Integer uarfcn() {
        return uarfcn;
    }

    /**
     * <p>
     * Cell parameters for TD-SCDMA.
     * </p>
     * 
     * @return Cell parameters for TD-SCDMA.
     */
    public final Integer cellParams() {
        return cellParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uarfcn());
        hashCode = 31 * hashCode + Objects.hashCode(cellParams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TdscdmaLocalId)) {
            return false;
        }
        TdscdmaLocalId other = (TdscdmaLocalId) obj;
        return Objects.equals(uarfcn(), other.uarfcn()) && Objects.equals(cellParams(), other.cellParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TdscdmaLocalId").add("Uarfcn", uarfcn()).add("CellParams", cellParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uarfcn":
            return Optional.ofNullable(clazz.cast(uarfcn()));
        case "CellParams":
            return Optional.ofNullable(clazz.cast(cellParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Uarfcn", UARFCN_FIELD);
        map.put("CellParams", CELL_PARAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TdscdmaLocalId, T> g) {
        return obj -> g.apply((TdscdmaLocalId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TdscdmaLocalId> {
        /**
         * <p>
         * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number (UARFCN).
         * </p>
         * 
         * @param uarfcn
         *        TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number (UARFCN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uarfcn(Integer uarfcn);

        /**
         * <p>
         * Cell parameters for TD-SCDMA.
         * </p>
         * 
         * @param cellParams
         *        Cell parameters for TD-SCDMA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellParams(Integer cellParams);
    }

    static final class BuilderImpl implements Builder {
        private Integer uarfcn;

        private Integer cellParams;

        private BuilderImpl() {
        }

        private BuilderImpl(TdscdmaLocalId model) {
            uarfcn(model.uarfcn);
            cellParams(model.cellParams);
        }

        public final Integer getUarfcn() {
            return uarfcn;
        }

        public final void setUarfcn(Integer uarfcn) {
            this.uarfcn = uarfcn;
        }

        @Override
        public final Builder uarfcn(Integer uarfcn) {
            this.uarfcn = uarfcn;
            return this;
        }

        public final Integer getCellParams() {
            return cellParams;
        }

        public final void setCellParams(Integer cellParams) {
            this.cellParams = cellParams;
        }

        @Override
        public final Builder cellParams(Integer cellParams) {
            this.cellParams = cellParams;
            return this;
        }

        @Override
        public TdscdmaLocalId build() {
            return new TdscdmaLocalId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
