/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLogLevelsByResourceTypesRequest extends IotWirelessRequest implements
        ToCopyableBuilder<UpdateLogLevelsByResourceTypesRequest.Builder, UpdateLogLevelsByResourceTypesRequest> {
    private static final SdkField<String> DEFAULT_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultLogLevel").getter(getter(UpdateLogLevelsByResourceTypesRequest::defaultLogLevelAsString))
            .setter(setter(Builder::defaultLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLogLevel").build()).build();

    private static final SdkField<List<FuotaTaskLogOption>> FUOTA_TASK_LOG_OPTIONS_FIELD = SdkField
            .<List<FuotaTaskLogOption>> builder(MarshallingType.LIST)
            .memberName("FuotaTaskLogOptions")
            .getter(getter(UpdateLogLevelsByResourceTypesRequest::fuotaTaskLogOptions))
            .setter(setter(Builder::fuotaTaskLogOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuotaTaskLogOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FuotaTaskLogOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(FuotaTaskLogOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WirelessDeviceLogOption>> WIRELESS_DEVICE_LOG_OPTIONS_FIELD = SdkField
            .<List<WirelessDeviceLogOption>> builder(MarshallingType.LIST)
            .memberName("WirelessDeviceLogOptions")
            .getter(getter(UpdateLogLevelsByResourceTypesRequest::wirelessDeviceLogOptions))
            .setter(setter(Builder::wirelessDeviceLogOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceLogOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WirelessDeviceLogOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(WirelessDeviceLogOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WirelessGatewayLogOption>> WIRELESS_GATEWAY_LOG_OPTIONS_FIELD = SdkField
            .<List<WirelessGatewayLogOption>> builder(MarshallingType.LIST)
            .memberName("WirelessGatewayLogOptions")
            .getter(getter(UpdateLogLevelsByResourceTypesRequest::wirelessGatewayLogOptions))
            .setter(setter(Builder::wirelessGatewayLogOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayLogOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WirelessGatewayLogOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(WirelessGatewayLogOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_LOG_LEVEL_FIELD,
            FUOTA_TASK_LOG_OPTIONS_FIELD, WIRELESS_DEVICE_LOG_OPTIONS_FIELD, WIRELESS_GATEWAY_LOG_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String defaultLogLevel;

    private final List<FuotaTaskLogOption> fuotaTaskLogOptions;

    private final List<WirelessDeviceLogOption> wirelessDeviceLogOptions;

    private final List<WirelessGatewayLogOption> wirelessGatewayLogOptions;

    private UpdateLogLevelsByResourceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.defaultLogLevel = builder.defaultLogLevel;
        this.fuotaTaskLogOptions = builder.fuotaTaskLogOptions;
        this.wirelessDeviceLogOptions = builder.wirelessDeviceLogOptions;
        this.wirelessGatewayLogOptions = builder.wirelessGatewayLogOptions;
    }

    /**
     * Returns the value of the DefaultLogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The value of the DefaultLogLevel property for this object.
     * @see LogLevel
     */
    public final LogLevel defaultLogLevel() {
        return LogLevel.fromValue(defaultLogLevel);
    }

    /**
     * Returns the value of the DefaultLogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The value of the DefaultLogLevel property for this object.
     * @see LogLevel
     */
    public final String defaultLogLevelAsString() {
        return defaultLogLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the FuotaTaskLogOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFuotaTaskLogOptions() {
        return fuotaTaskLogOptions != null && !(fuotaTaskLogOptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the FuotaTaskLogOptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFuotaTaskLogOptions} method.
     * </p>
     * 
     * @return The value of the FuotaTaskLogOptions property for this object.
     */
    public final List<FuotaTaskLogOption> fuotaTaskLogOptions() {
        return fuotaTaskLogOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDeviceLogOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessDeviceLogOptions() {
        return wirelessDeviceLogOptions != null && !(wirelessDeviceLogOptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the WirelessDeviceLogOptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDeviceLogOptions} method.
     * </p>
     * 
     * @return The value of the WirelessDeviceLogOptions property for this object.
     */
    public final List<WirelessDeviceLogOption> wirelessDeviceLogOptions() {
        return wirelessDeviceLogOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessGatewayLogOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWirelessGatewayLogOptions() {
        return wirelessGatewayLogOptions != null && !(wirelessGatewayLogOptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the WirelessGatewayLogOptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessGatewayLogOptions} method.
     * </p>
     * 
     * @return The value of the WirelessGatewayLogOptions property for this object.
     */
    public final List<WirelessGatewayLogOption> wirelessGatewayLogOptions() {
        return wirelessGatewayLogOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFuotaTaskLogOptions() ? fuotaTaskLogOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDeviceLogOptions() ? wirelessDeviceLogOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGatewayLogOptions() ? wirelessGatewayLogOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogLevelsByResourceTypesRequest)) {
            return false;
        }
        UpdateLogLevelsByResourceTypesRequest other = (UpdateLogLevelsByResourceTypesRequest) obj;
        return Objects.equals(defaultLogLevelAsString(), other.defaultLogLevelAsString())
                && hasFuotaTaskLogOptions() == other.hasFuotaTaskLogOptions()
                && Objects.equals(fuotaTaskLogOptions(), other.fuotaTaskLogOptions())
                && hasWirelessDeviceLogOptions() == other.hasWirelessDeviceLogOptions()
                && Objects.equals(wirelessDeviceLogOptions(), other.wirelessDeviceLogOptions())
                && hasWirelessGatewayLogOptions() == other.hasWirelessGatewayLogOptions()
                && Objects.equals(wirelessGatewayLogOptions(), other.wirelessGatewayLogOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLogLevelsByResourceTypesRequest").add("DefaultLogLevel", defaultLogLevelAsString())
                .add("FuotaTaskLogOptions", hasFuotaTaskLogOptions() ? fuotaTaskLogOptions() : null)
                .add("WirelessDeviceLogOptions", hasWirelessDeviceLogOptions() ? wirelessDeviceLogOptions() : null)
                .add("WirelessGatewayLogOptions", hasWirelessGatewayLogOptions() ? wirelessGatewayLogOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultLogLevel":
            return Optional.ofNullable(clazz.cast(defaultLogLevelAsString()));
        case "FuotaTaskLogOptions":
            return Optional.ofNullable(clazz.cast(fuotaTaskLogOptions()));
        case "WirelessDeviceLogOptions":
            return Optional.ofNullable(clazz.cast(wirelessDeviceLogOptions()));
        case "WirelessGatewayLogOptions":
            return Optional.ofNullable(clazz.cast(wirelessGatewayLogOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultLogLevel", DEFAULT_LOG_LEVEL_FIELD);
        map.put("FuotaTaskLogOptions", FUOTA_TASK_LOG_OPTIONS_FIELD);
        map.put("WirelessDeviceLogOptions", WIRELESS_DEVICE_LOG_OPTIONS_FIELD);
        map.put("WirelessGatewayLogOptions", WIRELESS_GATEWAY_LOG_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogLevelsByResourceTypesRequest, T> g) {
        return obj -> g.apply((UpdateLogLevelsByResourceTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLogLevelsByResourceTypesRequest> {
        /**
         * Sets the value of the DefaultLogLevel property for this object.
         *
         * @param defaultLogLevel
         *        The new value for the DefaultLogLevel property for this object.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(String defaultLogLevel);

        /**
         * Sets the value of the DefaultLogLevel property for this object.
         *
         * @param defaultLogLevel
         *        The new value for the DefaultLogLevel property for this object.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(LogLevel defaultLogLevel);

        /**
         * Sets the value of the FuotaTaskLogOptions property for this object.
         *
         * @param fuotaTaskLogOptions
         *        The new value for the FuotaTaskLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fuotaTaskLogOptions(Collection<FuotaTaskLogOption> fuotaTaskLogOptions);

        /**
         * Sets the value of the FuotaTaskLogOptions property for this object.
         *
         * @param fuotaTaskLogOptions
         *        The new value for the FuotaTaskLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fuotaTaskLogOptions(FuotaTaskLogOption... fuotaTaskLogOptions);

        /**
         * Sets the value of the FuotaTaskLogOptions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOption.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOption.Builder#build()} is called
         * immediately and its result is passed to {@link #fuotaTaskLogOptions(List<FuotaTaskLogOption>)}.
         * 
         * @param fuotaTaskLogOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fuotaTaskLogOptions(java.util.Collection<FuotaTaskLogOption>)
         */
        Builder fuotaTaskLogOptions(Consumer<FuotaTaskLogOption.Builder>... fuotaTaskLogOptions);

        /**
         * Sets the value of the WirelessDeviceLogOptions property for this object.
         *
         * @param wirelessDeviceLogOptions
         *        The new value for the WirelessDeviceLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> wirelessDeviceLogOptions);

        /**
         * Sets the value of the WirelessDeviceLogOptions property for this object.
         *
         * @param wirelessDeviceLogOptions
         *        The new value for the WirelessDeviceLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDeviceLogOptions(WirelessDeviceLogOption... wirelessDeviceLogOptions);

        /**
         * Sets the value of the WirelessDeviceLogOptions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption.Builder#build()} is called
         * immediately and its result is passed to {@link #wirelessDeviceLogOptions(List<WirelessDeviceLogOption>)}.
         * 
         * @param wirelessDeviceLogOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessDeviceLogOptions(java.util.Collection<WirelessDeviceLogOption>)
         */
        Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder>... wirelessDeviceLogOptions);

        /**
         * Sets the value of the WirelessGatewayLogOptions property for this object.
         *
         * @param wirelessGatewayLogOptions
         *        The new value for the WirelessGatewayLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> wirelessGatewayLogOptions);

        /**
         * Sets the value of the WirelessGatewayLogOptions property for this object.
         *
         * @param wirelessGatewayLogOptions
         *        The new value for the WirelessGatewayLogOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGatewayLogOptions(WirelessGatewayLogOption... wirelessGatewayLogOptions);

        /**
         * Sets the value of the WirelessGatewayLogOptions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption.Builder#build()} is called
         * immediately and its result is passed to {@link #wirelessGatewayLogOptions(List<WirelessGatewayLogOption>)}.
         * 
         * @param wirelessGatewayLogOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wirelessGatewayLogOptions(java.util.Collection<WirelessGatewayLogOption>)
         */
        Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder>... wirelessGatewayLogOptions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String defaultLogLevel;

        private List<FuotaTaskLogOption> fuotaTaskLogOptions = DefaultSdkAutoConstructList.getInstance();

        private List<WirelessDeviceLogOption> wirelessDeviceLogOptions = DefaultSdkAutoConstructList.getInstance();

        private List<WirelessGatewayLogOption> wirelessGatewayLogOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogLevelsByResourceTypesRequest model) {
            super(model);
            defaultLogLevel(model.defaultLogLevel);
            fuotaTaskLogOptions(model.fuotaTaskLogOptions);
            wirelessDeviceLogOptions(model.wirelessDeviceLogOptions);
            wirelessGatewayLogOptions(model.wirelessGatewayLogOptions);
        }

        public final String getDefaultLogLevel() {
            return defaultLogLevel;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel == null ? null : defaultLogLevel.toString());
            return this;
        }

        public final List<FuotaTaskLogOption.Builder> getFuotaTaskLogOptions() {
            List<FuotaTaskLogOption.Builder> result = FuotaTaskLogOptionListCopier.copyToBuilder(this.fuotaTaskLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFuotaTaskLogOptions(Collection<FuotaTaskLogOption.BuilderImpl> fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions = FuotaTaskLogOptionListCopier.copyFromBuilder(fuotaTaskLogOptions);
        }

        @Override
        public final Builder fuotaTaskLogOptions(Collection<FuotaTaskLogOption> fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions = FuotaTaskLogOptionListCopier.copy(fuotaTaskLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskLogOptions(FuotaTaskLogOption... fuotaTaskLogOptions) {
            fuotaTaskLogOptions(Arrays.asList(fuotaTaskLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskLogOptions(Consumer<FuotaTaskLogOption.Builder>... fuotaTaskLogOptions) {
            fuotaTaskLogOptions(Stream.of(fuotaTaskLogOptions).map(c -> FuotaTaskLogOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<WirelessDeviceLogOption.Builder> getWirelessDeviceLogOptions() {
            List<WirelessDeviceLogOption.Builder> result = WirelessDeviceLogOptionListCopier
                    .copyToBuilder(this.wirelessDeviceLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceLogOptions(Collection<WirelessDeviceLogOption.BuilderImpl> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copyFromBuilder(wirelessDeviceLogOptions);
        }

        @Override
        public final Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copy(wirelessDeviceLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(WirelessDeviceLogOption... wirelessDeviceLogOptions) {
            wirelessDeviceLogOptions(Arrays.asList(wirelessDeviceLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder>... wirelessDeviceLogOptions) {
            wirelessDeviceLogOptions(Stream.of(wirelessDeviceLogOptions)
                    .map(c -> WirelessDeviceLogOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WirelessGatewayLogOption.Builder> getWirelessGatewayLogOptions() {
            List<WirelessGatewayLogOption.Builder> result = WirelessGatewayLogOptionListCopier
                    .copyToBuilder(this.wirelessGatewayLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessGatewayLogOptions(Collection<WirelessGatewayLogOption.BuilderImpl> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copyFromBuilder(wirelessGatewayLogOptions);
        }

        @Override
        public final Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copy(wirelessGatewayLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(WirelessGatewayLogOption... wirelessGatewayLogOptions) {
            wirelessGatewayLogOptions(Arrays.asList(wirelessGatewayLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder>... wirelessGatewayLogOptions) {
            wirelessGatewayLogOptions(Stream.of(wirelessGatewayLogOptions)
                    .map(c -> WirelessGatewayLogOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLogLevelsByResourceTypesRequest build() {
            return new UpdateLogLevelsByResourceTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
