/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log options for a wireless gateway event and can be used to set log levels for a specific wireless gateway event.
 * </p>
 * <p>
 * For a LoRaWAN gateway, possible events for a log message are <code>CUPS_Request</code> and <code>Certificate</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessGatewayEventLogOption implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessGatewayEventLogOption.Builder, WirelessGatewayEventLogOption> {
    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Event")
            .getter(getter(WirelessGatewayEventLogOption::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(WirelessGatewayEventLogOption::logLevelAsString))
            .setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, LOG_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String event;

    private final String logLevel;

    private WirelessGatewayEventLogOption(BuilderImpl builder) {
        this.event = builder.event;
        this.logLevel = builder.logLevel;
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link WirelessGatewayEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see WirelessGatewayEvent
     */
    public final WirelessGatewayEvent event() {
        return WirelessGatewayEvent.fromValue(event);
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link WirelessGatewayEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see WirelessGatewayEvent
     */
    public final String eventAsString() {
        return event;
    }

    /**
     * Returns the value of the LogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The value of the LogLevel property for this object.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * Returns the value of the LogLevel property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The value of the LogLevel property for this object.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessGatewayEventLogOption)) {
            return false;
        }
        WirelessGatewayEventLogOption other = (WirelessGatewayEventLogOption) obj;
        return Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(logLevelAsString(), other.logLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessGatewayEventLogOption").add("Event", eventAsString())
                .add("LogLevel", logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Event", EVENT_FIELD);
        map.put("LogLevel", LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WirelessGatewayEventLogOption, T> g) {
        return obj -> g.apply((WirelessGatewayEventLogOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessGatewayEventLogOption> {
        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see WirelessGatewayEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayEvent
         */
        Builder event(String event);

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see WirelessGatewayEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessGatewayEvent
         */
        Builder event(WirelessGatewayEvent event);

        /**
         * Sets the value of the LogLevel property for this object.
         *
         * @param logLevel
         *        The new value for the LogLevel property for this object.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * Sets the value of the LogLevel property for this object.
         *
         * @param logLevel
         *        The new value for the LogLevel property for this object.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);
    }

    static final class BuilderImpl implements Builder {
        private String event;

        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessGatewayEventLogOption model) {
            event(model.event);
            logLevel(model.logLevel);
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(WirelessGatewayEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        @Override
        public WirelessGatewayEventLogOption build() {
            return new WirelessGatewayEventLogOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
