/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a live video stream that has been ingested and distributed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stream implements SdkPojo, Serializable, ToCopyableBuilder<Stream.Builder, Stream> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stream::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stream::playbackUrl)).setter(setter(Builder::playbackUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Stream::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stream::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stream::healthAsString)).setter(setter(Builder::health))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<Long> VIEWER_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Stream::viewerCount)).setter(setter(Builder::viewerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            PLAYBACK_URL_FIELD, START_TIME_FIELD, STATE_FIELD, HEALTH_FIELD, VIEWER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String playbackUrl;

    private final Instant startTime;

    private final String state;

    private final String health;

    private final Long viewerCount;

    private Stream(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.playbackUrl = builder.playbackUrl;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.health = builder.health;
        this.viewerCount = builder.viewerCount;
    }

    /**
     * <p>
     * Channel ARN for the stream.
     * </p>
     * 
     * @return Channel ARN for the stream.
     */
    public String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * URL of the video master manifest, required by the video player to play the HLS stream.
     * </p>
     * 
     * @return URL of the video master manifest, required by the video player to play the HLS stream.
     */
    public String playbackUrl() {
        return playbackUrl;
    }

    /**
     * <p>
     * ISO-8601 formatted timestamp of the stream’s start.
     * </p>
     * 
     * @return ISO-8601 formatted timestamp of the stream’s start.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The stream’s state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The stream’s state.
     * @see StreamState
     */
    public StreamState state() {
        return StreamState.fromValue(state);
    }

    /**
     * <p>
     * The stream’s state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The stream’s state.
     * @see StreamState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public StreamHealth health() {
        return StreamHealth.fromValue(health);
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public String healthAsString() {
        return health;
    }

    /**
     * <p>
     * Number of current viewers of the stream.
     * </p>
     * 
     * @return Number of current viewers of the stream.
     */
    public Long viewerCount() {
        return viewerCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(playbackUrl(), other.playbackUrl())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(healthAsString(), other.healthAsString()) && Objects.equals(viewerCount(), other.viewerCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Stream").add("ChannelArn", channelArn()).add("PlaybackUrl", playbackUrl())
                .add("StartTime", startTime()).add("State", stateAsString()).add("Health", healthAsString())
                .add("ViewerCount", viewerCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "playbackUrl":
            return Optional.ofNullable(clazz.cast(playbackUrl()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "health":
            return Optional.ofNullable(clazz.cast(healthAsString()));
        case "viewerCount":
            return Optional.ofNullable(clazz.cast(viewerCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stream, T> g) {
        return obj -> g.apply((Stream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stream> {
        /**
         * <p>
         * Channel ARN for the stream.
         * </p>
         * 
         * @param channelArn
         *        Channel ARN for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * URL of the video master manifest, required by the video player to play the HLS stream.
         * </p>
         * 
         * @param playbackUrl
         *        URL of the video master manifest, required by the video player to play the HLS stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackUrl(String playbackUrl);

        /**
         * <p>
         * ISO-8601 formatted timestamp of the stream’s start.
         * </p>
         * 
         * @param startTime
         *        ISO-8601 formatted timestamp of the stream’s start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The stream’s state.
         * </p>
         * 
         * @param state
         *        The stream’s state.
         * @see StreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamState
         */
        Builder state(String state);

        /**
         * <p>
         * The stream’s state.
         * </p>
         * 
         * @param state
         *        The stream’s state.
         * @see StreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamState
         */
        Builder state(StreamState state);

        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(String health);

        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(StreamHealth health);

        /**
         * <p>
         * Number of current viewers of the stream.
         * </p>
         * 
         * @param viewerCount
         *        Number of current viewers of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCount(Long viewerCount);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String playbackUrl;

        private Instant startTime;

        private String state;

        private String health;

        private Long viewerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            channelArn(model.channelArn);
            playbackUrl(model.playbackUrl);
            startTime(model.startTime);
            state(model.state);
            health(model.health);
            viewerCount(model.viewerCount);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getPlaybackUrl() {
            return playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getHealth() {
            return health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(StreamHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final Long getViewerCount() {
            return viewerCount;
        }

        @Override
        public final Builder viewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
            return this;
        }

        public final void setViewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
        }

        @Override
        public Stream build() {
            return new Stream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
