/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse;
import software.amazon.awssdk.services.ivs.model.PlaybackKeyPairSummary;

public class ListPlaybackKeyPairsIterable
implements SdkIterable<ListPlaybackKeyPairsResponse> {
    private final IvsClient client;
    private final ListPlaybackKeyPairsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlaybackKeyPairsIterable(IvsClient client, ListPlaybackKeyPairsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPlaybackKeyPairsResponseFetcher();
    }

    public Iterator<ListPlaybackKeyPairsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlaybackKeyPairSummary> keyPairs() {
        Function<ListPlaybackKeyPairsResponse, Iterator> getIterator = response -> {
            if (response != null && response.keyPairs() != null) {
                return response.keyPairs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlaybackKeyPairsResponseFetcher
    implements SyncPageFetcher<ListPlaybackKeyPairsResponse> {
        private ListPlaybackKeyPairsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackKeyPairsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlaybackKeyPairsResponse nextPage(ListPlaybackKeyPairsResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackKeyPairsIterable.this.client.listPlaybackKeyPairs(ListPlaybackKeyPairsIterable.this.firstRequest);
            }
            return ListPlaybackKeyPairsIterable.this.client.listPlaybackKeyPairs((ListPlaybackKeyPairsRequest)((Object)ListPlaybackKeyPairsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

