/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.Stream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, GetStreamResponse> {
    private static final SdkField<Stream> STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetStreamResponse.getter(GetStreamResponse::stream)).setter(GetStreamResponse.setter(Builder::stream)).constructor(Stream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_FIELD));
    private final Stream stream;

    private GetStreamResponse(BuilderImpl builder) {
        super(builder);
        this.stream = builder.stream;
    }

    public Stream stream() {
        return this.stream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stream());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamResponse)) {
            return false;
        }
        GetStreamResponse other = (GetStreamResponse)((Object)obj);
        return Objects.equals(this.stream(), other.stream());
    }

    public String toString() {
        return ToString.builder((String)"GetStreamResponse").add("Stream", (Object)this.stream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stream": {
                return Optional.ofNullable(clazz.cast(this.stream()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamResponse, T> g) {
        return obj -> g.apply((GetStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private Stream stream;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamResponse model) {
            super(model);
            this.stream(model.stream);
        }

        public final Stream.Builder getStream() {
            return this.stream != null ? this.stream.toBuilder() : null;
        }

        @Override
        public final Builder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        public final void setStream(Stream.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        @Override
        public GetStreamResponse build() {
            return new GetStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamResponse> {
        public Builder stream(Stream var1);

        default public Builder stream(Consumer<Stream.Builder> stream) {
            return this.stream((Stream)((Stream.Builder)Stream.builder().applyMutation(stream)).build());
        }
    }
}

