/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error related to a specific channel, specified by its ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchError implements SdkPojo, Serializable, ToCopyableBuilder<BatchError.Builder, BatchError> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchError::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CODE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String code;

    private final String message;

    private BatchError(BuilderImpl builder) {
        this.arn = builder.arn;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * Channel ARN.
     * </p>
     * 
     * @return Channel ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Error code.
     * </p>
     * 
     * @return Error code.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * Error message, determined by the application.
     * </p>
     * 
     * @return Error message, determined by the application.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchError)) {
            return false;
        }
        BatchError other = (BatchError) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchError").add("Arn", arn()).add("Code", code()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchError, T> g) {
        return obj -> g.apply((BatchError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchError> {
        /**
         * <p>
         * Channel ARN.
         * </p>
         * 
         * @param arn
         *        Channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Error code.
         * </p>
         * 
         * @param code
         *        Error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Error message, determined by the application.
         * </p>
         * 
         * @param message
         *        Error message, determined by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchError model) {
            arn(model.arn);
            code(model.code);
            message(model.message);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public BatchError build() {
            return new BatchError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
