/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsResponse extends IvsResponse implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private static final SdkField<List<StreamSummary>> STREAMS_FIELD = SdkField
            .<List<StreamSummary>> builder(MarshallingType.LIST)
            .memberName("streams")
            .getter(getter(ListStreamsResponse::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StreamSummary> streams;

    private final String nextToken;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Streams property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of streams.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStreams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of streams.
     */
    public List<StreamSummary> streams() {
        return streams;
    }

    /**
     * <p>
     * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     * 
     * @return If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *         the next set.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streams());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return Objects.equals(streams(), other.streams()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStreamsResponse").add("Streams", streams()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * List of streams.
         * </p>
         * 
         * @param streams
         *        List of streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<StreamSummary> streams);

        /**
         * <p>
         * List of streams.
         * </p>
         * 
         * @param streams
         *        List of streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(StreamSummary... streams);

        /**
         * <p>
         * List of streams.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamSummary>.Builder} avoiding the need
         * to create one manually via {@link List<StreamSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #streams(List<StreamSummary>)}.
         * 
         * @param streams
         *        a consumer that will call methods on {@link List<StreamSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(List<StreamSummary>)
         */
        Builder streams(Consumer<StreamSummary.Builder>... streams);

        /**
         * <p>
         * If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
         * next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to
         *        get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<StreamSummary> streams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            streams(model.streams);
            nextToken(model.nextToken);
        }

        public final Collection<StreamSummary.Builder> getStreams() {
            return streams != null ? streams.stream().map(StreamSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streams(Collection<StreamSummary> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(StreamSummary... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<StreamSummary.Builder>... streams) {
            streams(Stream.of(streams).map(c -> StreamSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreams(Collection<StreamSummary.BuilderImpl> streams) {
            this.streams = StreamListCopier.copyFromBuilder(streams);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
