/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetChannelRequest extends IvsRequest implements
        ToCopyableBuilder<BatchGetChannelRequest.Builder, BatchGetChannelRequest> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("arns")
            .getter(getter(BatchGetChannelRequest::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD));

    private final List<String> arns;

    private BatchGetChannelRequest(BuilderImpl builder) {
        super(builder);
        this.arns = builder.arns;
    }

    /**
     * Returns true if the Arns property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of ARNs, one per channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Array of ARNs, one per channel.
     */
    public List<String> arns() {
        return arns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetChannelRequest)) {
            return false;
        }
        BatchGetChannelRequest other = (BatchGetChannelRequest) obj;
        return Objects.equals(arns(), other.arns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetChannelRequest").add("Arns", arns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arns":
            return Optional.ofNullable(clazz.cast(arns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetChannelRequest, T> g) {
        return obj -> g.apply((BatchGetChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetChannelRequest> {
        /**
         * <p>
         * Array of ARNs, one per channel.
         * </p>
         * 
         * @param arns
         *        Array of ARNs, one per channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * Array of ARNs, one per channel.
         * </p>
         * 
         * @param arns
         *        Array of ARNs, one per channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetChannelRequest model) {
            super(model);
            arns(model.arns);
        }

        public final Collection<String> getArns() {
            return arns;
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = ChannelArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = ChannelArnListCopier.copy(arns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetChannelRequest build() {
            return new BatchGetChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
