/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends IvsRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(CreateChannelRequest::latencyModeAsString))
            .setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateChannelRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(CreateChannelRequest::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            LATENCY_MODE_FIELD, TYPE_FIELD, AUTHORIZED_FIELD, TAGS_FIELD));

    private final String name;

    private final String latencyMode;

    private final String type;

    private final Boolean authorized;

    private final Map<String, String> tags;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.latencyMode = builder.latencyMode;
        this.type = builder.type;
        this.authorized = builder.authorized;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Channel latency mode. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>STANDARD</code>.
     * @see ChannelType
     */
    public ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>STANDARD</code>.
     * @see ChannelType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Whether the channel is authorized. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is authorized. Default: <code>false</code>.
     */
    public Boolean authorized() {
        return authorized;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * See <a>Channel$tags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return See <a>Channel$tags</a>.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(latencyModeAsString(), other.latencyModeAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(authorized(), other.authorized())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateChannelRequest").add("Name", name()).add("LatencyMode", latencyModeAsString())
                .add("Type", typeAsString()).add("Authorized", authorized()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Channel latency mode. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>STANDARD</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>STANDARD</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Whether the channel is authorized. Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is authorized. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * See <a>Channel$tags</a>.
         * </p>
         * 
         * @param tags
         *        See <a>Channel$tags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private String name;

        private String latencyMode;

        private String type;

        private Boolean authorized;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            name(model.name);
            latencyMode(model.latencyMode);
            type(model.type);
            authorized(model.authorized);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
