/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.BatchError;
import software.amazon.awssdk.services.ivs.model.BatchErrorsCopier;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.StreamKey;
import software.amazon.awssdk.services.ivs.model.StreamKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetStreamKeyResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, BatchGetStreamKeyResponse> {
    private static final SdkField<List<StreamKey>> STREAM_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamKeys").getter(BatchGetStreamKeyResponse.getter(BatchGetStreamKeyResponse::streamKeys)).setter(BatchGetStreamKeyResponse.setter(Builder::streamKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetStreamKeyResponse.getter(BatchGetStreamKeyResponse::errors)).setter(BatchGetStreamKeyResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_KEYS_FIELD, ERRORS_FIELD));
    private final List<StreamKey> streamKeys;
    private final List<BatchError> errors;

    private BatchGetStreamKeyResponse(BuilderImpl builder) {
        super(builder);
        this.streamKeys = builder.streamKeys;
        this.errors = builder.errors;
    }

    public boolean hasStreamKeys() {
        return this.streamKeys != null && !(this.streamKeys instanceof SdkAutoConstructList);
    }

    public List<StreamKey> streamKeys() {
        return this.streamKeys;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<BatchError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStreamKeyResponse)) {
            return false;
        }
        BatchGetStreamKeyResponse other = (BatchGetStreamKeyResponse)((Object)obj);
        return Objects.equals(this.streamKeys(), other.streamKeys()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetStreamKeyResponse").add("StreamKeys", this.streamKeys()).add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamKeys": {
                return Optional.ofNullable(clazz.cast(this.streamKeys()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStreamKeyResponse, T> g) {
        return obj -> g.apply((BatchGetStreamKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private List<StreamKey> streamKeys = DefaultSdkAutoConstructList.getInstance();
        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStreamKeyResponse model) {
            super(model);
            this.streamKeys(model.streamKeys);
            this.errors(model.errors);
        }

        public final Collection<StreamKey.Builder> getStreamKeys() {
            return this.streamKeys != null ? (Collection)this.streamKeys.stream().map(StreamKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streamKeys(Collection<StreamKey> streamKeys) {
            this.streamKeys = StreamKeysCopier.copy(streamKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(StreamKey ... streamKeys) {
            this.streamKeys(Arrays.asList(streamKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(Consumer<StreamKey.Builder> ... streamKeys) {
            this.streamKeys(Stream.of(streamKeys).map(c -> (StreamKey)((StreamKey.Builder)StreamKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamKeys(Collection<StreamKey.BuilderImpl> streamKeys) {
            this.streamKeys = StreamKeysCopier.copyFromBuilder(streamKeys);
        }

        public final Collection<BatchError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(BatchError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchError)((BatchError.Builder)BatchError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchGetStreamKeyResponse build() {
            return new BatchGetStreamKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetStreamKeyResponse> {
        public Builder streamKeys(Collection<StreamKey> var1);

        public Builder streamKeys(StreamKey ... var1);

        public Builder streamKeys(Consumer<StreamKey.Builder> ... var1);

        public Builder errors(Collection<BatchError> var1);

        public Builder errors(BatchError ... var1);

        public Builder errors(Consumer<BatchError.Builder> ... var1);
    }
}

