/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetChannelResponse extends IvsResponse implements
        ToCopyableBuilder<BatchGetChannelResponse.Builder, BatchGetChannelResponse> {
    private static final SdkField<List<Channel>> CHANNELS_FIELD = SdkField
            .<List<Channel>> builder(MarshallingType.LIST)
            .memberName("channels")
            .getter(getter(BatchGetChannelResponse::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Channel> builder(MarshallingType.SDK_POJO)
                                            .constructor(Channel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField
            .<List<BatchError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetChannelResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, ERRORS_FIELD));

    private final List<Channel> channels;

    private final List<BatchError> errors;

    private BatchGetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Channels property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Channels property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Channels property for this object.
     */
    public List<Channel> channels() {
        return channels;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each error object is related to a specific ARN in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Each error object is related to a specific ARN in the request.
     */
    public List<BatchError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetChannelResponse)) {
            return false;
        }
        BatchGetChannelResponse other = (BatchGetChannelResponse) obj;
        return hasChannels() == other.hasChannels() && Objects.equals(channels(), other.channels())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetChannelResponse").add("Channels", hasChannels() ? channels() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetChannelResponse, T> g) {
        return obj -> g.apply((BatchGetChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetChannelResponse> {
        /**
         * Sets the value of the Channels property for this object.
         *
         * @param channels
         *        The new value for the Channels property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * Sets the value of the Channels property for this object.
         *
         * @param channels
         *        The new value for the Channels property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);

        /**
         * Sets the value of the Channels property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Channel>.Builder} avoiding the need to
         * create one manually via {@link List<Channel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Channel>.Builder#build()} is called immediately and its
         * result is passed to {@link #channels(List<Channel>)}.
         * 
         * @param channels
         *        a consumer that will call methods on {@link List<Channel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channels(List<Channel>)
         */
        Builder channels(Consumer<Channel.Builder>... channels);

        /**
         * <p>
         * Each error object is related to a specific ARN in the request.
         * </p>
         * 
         * @param errors
         *        Each error object is related to a specific ARN in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchError> errors);

        /**
         * <p>
         * Each error object is related to a specific ARN in the request.
         * </p>
         * 
         * @param errors
         *        Each error object is related to a specific ARN in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchError... errors);

        /**
         * <p>
         * Each error object is related to a specific ARN in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchError>.Builder} avoiding the need to
         * create one manually via {@link List<BatchError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<BatchError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchError>)
         */
        Builder errors(Consumer<BatchError.Builder>... errors);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<Channel> channels = DefaultSdkAutoConstructList.getInstance();

        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetChannelResponse model) {
            super(model);
            channels(model.channels);
            errors(model.errors);
        }

        public final Collection<Channel.Builder> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels != null ? channels.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<Channel.Builder>... channels) {
            channels(Stream.of(channels).map(c -> Channel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannels(Collection<Channel.BuilderImpl> channels) {
            this.channels = ChannelsCopier.copyFromBuilder(channels);
        }

        public final Collection<BatchError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(BatchError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchGetChannelResponse build() {
            return new BatchGetChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
