/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends IvsRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateChannelRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(UpdateChannelRequest::latencyModeAsString))
            .setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateChannelRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(UpdateChannelRequest::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            LATENCY_MODE_FIELD, TYPE_FIELD, AUTHORIZED_FIELD));

    private final String arn;

    private final String name;

    private final String latencyMode;

    private final String type;

    private final Boolean authorized;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.latencyMode = builder.latencyMode;
        this.type = builder.type;
        this.authorized = builder.authorized;
    }

    /**
     * <p>
     * ARN of the channel to be updated.
     * </p>
     * 
     * @return ARN of the channel to be updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Channel latency mode. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>STANDARD</code>.
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>STANDARD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>STANDARD</code>.
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Whether the channel is authorized. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is authorized. Default: <code>false</code>.
     */
    public final Boolean authorized() {
        return authorized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(authorized(), other.authorized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelRequest").add("Arn", arn()).add("Name", name())
                .add("LatencyMode", latencyModeAsString()).add("Type", typeAsString()).add("Authorized", authorized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * <p>
         * ARN of the channel to be updated.
         * </p>
         * 
         * @param arn
         *        ARN of the channel to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Channel latency mode. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>STANDARD</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>STANDARD</code>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>STANDARD</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Whether the channel is authorized. Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is authorized. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String latencyMode;

        private String type;

        private Boolean authorized;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            latencyMode(model.latencyMode);
            type(model.type);
            authorized(model.authorized);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
