/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetStreamKeyResponse extends IvsResponse implements
        ToCopyableBuilder<BatchGetStreamKeyResponse.Builder, BatchGetStreamKeyResponse> {
    private static final SdkField<List<StreamKey>> STREAM_KEYS_FIELD = SdkField
            .<List<StreamKey>> builder(MarshallingType.LIST)
            .memberName("streamKeys")
            .getter(getter(BatchGetStreamKeyResponse::streamKeys))
            .setter(setter(Builder::streamKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchError>> ERRORS_FIELD = SdkField
            .<List<BatchError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetStreamKeyResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_KEYS_FIELD,
            ERRORS_FIELD));

    private final List<StreamKey> streamKeys;

    private final List<BatchError> errors;

    private BatchGetStreamKeyResponse(BuilderImpl builder) {
        super(builder);
        this.streamKeys = builder.streamKeys;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the StreamKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStreamKeys() {
        return streamKeys != null && !(streamKeys instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the StreamKeys property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStreamKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the StreamKeys property for this object.
     */
    public final List<StreamKey> streamKeys() {
        return streamKeys;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Errors property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Errors property for this object.
     */
    public final List<BatchError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamKeys() ? streamKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStreamKeyResponse)) {
            return false;
        }
        BatchGetStreamKeyResponse other = (BatchGetStreamKeyResponse) obj;
        return hasStreamKeys() == other.hasStreamKeys() && Objects.equals(streamKeys(), other.streamKeys())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetStreamKeyResponse").add("StreamKeys", hasStreamKeys() ? streamKeys() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamKeys":
            return Optional.ofNullable(clazz.cast(streamKeys()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStreamKeyResponse, T> g) {
        return obj -> g.apply((BatchGetStreamKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetStreamKeyResponse> {
        /**
         * Sets the value of the StreamKeys property for this object.
         *
         * @param streamKeys
         *        The new value for the StreamKeys property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(Collection<StreamKey> streamKeys);

        /**
         * Sets the value of the StreamKeys property for this object.
         *
         * @param streamKeys
         *        The new value for the StreamKeys property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(StreamKey... streamKeys);

        /**
         * Sets the value of the StreamKeys property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<StreamKey>.Builder} avoiding the need to
         * create one manually via {@link List<StreamKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #streamKeys(List<StreamKey>)}.
         * 
         * @param streamKeys
         *        a consumer that will call methods on {@link List<StreamKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamKeys(List<StreamKey>)
         */
        Builder streamKeys(Consumer<StreamKey.Builder>... streamKeys);

        /**
         * Sets the value of the Errors property for this object.
         *
         * @param errors
         *        The new value for the Errors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchError> errors);

        /**
         * Sets the value of the Errors property for this object.
         *
         * @param errors
         *        The new value for the Errors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchError... errors);

        /**
         * Sets the value of the Errors property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<BatchError>.Builder} avoiding the need to
         * create one manually via {@link List<BatchError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<BatchError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<BatchError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchError>)
         */
        Builder errors(Consumer<BatchError.Builder>... errors);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<StreamKey> streamKeys = DefaultSdkAutoConstructList.getInstance();

        private List<BatchError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStreamKeyResponse model) {
            super(model);
            streamKeys(model.streamKeys);
            errors(model.errors);
        }

        public final Collection<StreamKey.Builder> getStreamKeys() {
            if (streamKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return streamKeys != null ? streamKeys.stream().map(StreamKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streamKeys(Collection<StreamKey> streamKeys) {
            this.streamKeys = StreamKeysCopier.copy(streamKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(StreamKey... streamKeys) {
            streamKeys(Arrays.asList(streamKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamKeys(Consumer<StreamKey.Builder>... streamKeys) {
            streamKeys(Stream.of(streamKeys).map(c -> StreamKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamKeys(Collection<StreamKey.BuilderImpl> streamKeys) {
            this.streamKeys = StreamKeysCopier.copyFromBuilder(streamKeys);
        }

        public final Collection<BatchError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(BatchError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchError> errors) {
            this.errors = BatchErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchError.BuilderImpl> errors) {
            this.errors = BatchErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchGetStreamKeyResponse build() {
            return new BatchGetStreamKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
