/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration of thumbnails for recorded video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThumbnailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThumbnailConfiguration.Builder, ThumbnailConfiguration> {
    private static final SdkField<String> RECORDING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingMode").getter(getter(ThumbnailConfiguration::recordingModeAsString))
            .setter(setter(Builder::recordingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()).build();

    private static final SdkField<Long> TARGET_INTERVAL_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("targetIntervalSeconds").getter(getter(ThumbnailConfiguration::targetIntervalSeconds))
            .setter(setter(Builder::targetIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDING_MODE_FIELD,
            TARGET_INTERVAL_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordingMode;

    private final Long targetIntervalSeconds;

    private ThumbnailConfiguration(BuilderImpl builder) {
        this.recordingMode = builder.recordingMode;
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
    }

    /**
     * <p>
     * Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingMode}
     * will return {@link RecordingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordingModeAsString}.
     * </p>
     * 
     * @return Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * @see RecordingMode
     */
    public final RecordingMode recordingMode() {
        return RecordingMode.fromValue(recordingMode);
    }

    /**
     * <p>
     * Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingMode}
     * will return {@link RecordingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordingModeAsString}.
     * </p>
     * 
     * @return Thumbnail recording mode. Default: <code>INTERVAL</code>.
     * @see RecordingMode
     */
    public final String recordingModeAsString() {
        return recordingMode;
    }

    /**
     * <p>
     * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
     * <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.
     * </p>
     * <p>
     * <b>Important:</b> Setting a value for <code>targetIntervalSeconds</code> does not guarantee that thumbnails are
     * generated at the specified interval. For thumbnails to be generated at the <code>targetIntervalSeconds</code>
     * interval, the <code>IDR/Keyframe</code> value for the input video must be less than the
     * <code>targetIntervalSeconds</code> value. See <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
     * Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in video-encoder
     * settings.
     * </p>
     * 
     * @return The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
     *         <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.</p>
     *         <p>
     *         <b>Important:</b> Setting a value for <code>targetIntervalSeconds</code> does not guarantee that
     *         thumbnails are generated at the specified interval. For thumbnails to be generated at the
     *         <code>targetIntervalSeconds</code> interval, the <code>IDR/Keyframe</code> value for the input video must
     *         be less than the <code>targetIntervalSeconds</code> value. See <a
     *         href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
     *         Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
     *         video-encoder settings.
     */
    public final Long targetIntervalSeconds() {
        return targetIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailConfiguration)) {
            return false;
        }
        ThumbnailConfiguration other = (ThumbnailConfiguration) obj;
        return Objects.equals(recordingModeAsString(), other.recordingModeAsString())
                && Objects.equals(targetIntervalSeconds(), other.targetIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThumbnailConfiguration").add("RecordingMode", recordingModeAsString())
                .add("TargetIntervalSeconds", targetIntervalSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordingMode":
            return Optional.ofNullable(clazz.cast(recordingModeAsString()));
        case "targetIntervalSeconds":
            return Optional.ofNullable(clazz.cast(targetIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailConfiguration, T> g) {
        return obj -> g.apply((ThumbnailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThumbnailConfiguration> {
        /**
         * <p>
         * Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * </p>
         * 
         * @param recordingMode
         *        Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * @see RecordingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingMode
         */
        Builder recordingMode(String recordingMode);

        /**
         * <p>
         * Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * </p>
         * 
         * @param recordingMode
         *        Thumbnail recording mode. Default: <code>INTERVAL</code>.
         * @see RecordingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingMode
         */
        Builder recordingMode(RecordingMode recordingMode);

        /**
         * <p>
         * The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
         * <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.
         * </p>
         * <p>
         * <b>Important:</b> Setting a value for <code>targetIntervalSeconds</code> does not guarantee that thumbnails
         * are generated at the specified interval. For thumbnails to be generated at the
         * <code>targetIntervalSeconds</code> interval, the <code>IDR/Keyframe</code> value for the input video must be
         * less than the <code>targetIntervalSeconds</code> value. See <a
         * href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
         * Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
         * video-encoder settings.
         * </p>
         * 
         * @param targetIntervalSeconds
         *        The targeted thumbnail-generation interval in seconds. This is configurable (and required) only if
         *        <code>recordingMode</code> is <code>INTERVAL</code>. Default: 60.</p>
         *        <p>
         *        <b>Important:</b> Setting a value for <code>targetIntervalSeconds</code> does not guarantee that
         *        thumbnails are generated at the specified interval. For thumbnails to be generated at the
         *        <code>targetIntervalSeconds</code> interval, the <code>IDR/Keyframe</code> value for the input video
         *        must be less than the <code>targetIntervalSeconds</code> value. See <a
         *        href="https://docs.aws.amazon.com/ivs/latest/userguide/streaming-config.html"> Amazon IVS Streaming
         *        Configuration</a> for information on setting <code>IDR/Keyframe</code> to the recommended value in
         *        video-encoder settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIntervalSeconds(Long targetIntervalSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String recordingMode;

        private Long targetIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailConfiguration model) {
            recordingMode(model.recordingMode);
            targetIntervalSeconds(model.targetIntervalSeconds);
        }

        public final String getRecordingMode() {
            return recordingMode;
        }

        public final void setRecordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
        }

        @Override
        @Transient
        public final Builder recordingMode(String recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode(recordingMode == null ? null : recordingMode.toString());
            return this;
        }

        public final Long getTargetIntervalSeconds() {
            return targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        @Transient
        public final Builder targetIntervalSeconds(Long targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        @Override
        public ThumbnailConfiguration build() {
            return new ThumbnailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
