/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportPlaybackKeyPairResponse extends IvsResponse implements
        ToCopyableBuilder<ImportPlaybackKeyPairResponse.Builder, ImportPlaybackKeyPairResponse> {
    private static final SdkField<PlaybackKeyPair> KEY_PAIR_FIELD = SdkField.<PlaybackKeyPair> builder(MarshallingType.SDK_POJO)
            .memberName("keyPair").getter(getter(ImportPlaybackKeyPairResponse::keyPair)).setter(setter(Builder::keyPair))
            .constructor(PlaybackKeyPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_FIELD));

    private final PlaybackKeyPair keyPair;

    private ImportPlaybackKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyPair = builder.keyPair;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final PlaybackKeyPair keyPair() {
        return keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportPlaybackKeyPairResponse)) {
            return false;
        }
        ImportPlaybackKeyPairResponse other = (ImportPlaybackKeyPairResponse) obj;
        return Objects.equals(keyPair(), other.keyPair());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportPlaybackKeyPairResponse").add("KeyPair", keyPair()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportPlaybackKeyPairResponse, T> g) {
        return obj -> g.apply((ImportPlaybackKeyPairResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ImportPlaybackKeyPairResponse> {
        /**
         * <p/>
         * 
         * @param keyPair
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(PlaybackKeyPair keyPair);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link PlaybackKeyPair.Builder} avoiding the need to
         * create one manually via {@link PlaybackKeyPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlaybackKeyPair.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPair(PlaybackKeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link PlaybackKeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(PlaybackKeyPair)
         */
        default Builder keyPair(Consumer<PlaybackKeyPair.Builder> keyPair) {
            return keyPair(PlaybackKeyPair.builder().applyMutation(keyPair).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private PlaybackKeyPair keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportPlaybackKeyPairResponse model) {
            super(model);
            keyPair(model.keyPair);
        }

        public final PlaybackKeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        public final void setKeyPair(PlaybackKeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        @Transient
        public final Builder keyPair(PlaybackKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        @Override
        public ImportPlaybackKeyPairResponse build() {
            return new ImportPlaybackKeyPairResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
