/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Channel::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Channel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(Channel::latencyModeAsString)).setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Channel::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingConfigurationArn").getter(getter(Channel::recordingConfigurationArn))
            .setter(setter(Builder::recordingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build())
            .build();

    private static final SdkField<String> INGEST_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestEndpoint").getter(getter(Channel::ingestEndpoint)).setter(setter(Builder::ingestEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoint").build()).build();

    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("playbackUrl").getter(getter(Channel::playbackUrl)).setter(setter(Builder::playbackUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(Channel::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Channel::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            LATENCY_MODE_FIELD, TYPE_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, INGEST_ENDPOINT_FIELD, PLAYBACK_URL_FIELD,
            AUTHORIZED_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String latencyMode;

    private final String type;

    private final String recordingConfigurationArn;

    private final String ingestEndpoint;

    private final String playbackUrl;

    private final Boolean authorized;

    private final Map<String, String> tags;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.latencyMode = builder.latencyMode;
        this.type = builder.type;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.ingestEndpoint = builder.ingestEndpoint;
        this.playbackUrl = builder.playbackUrl;
        this.authorized = builder.authorized;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Channel ARN.
     * </p>
     * 
     * @return Channel ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS
     * console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
     *         Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
     *         respectively.)
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS
     * console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
     *         Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
     *         respectively.)
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers
     * the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate
     * can be up to 8.5 Mbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
     * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
     *         viewers the best experience for their devices and network conditions. Vertical resolution can be up to
     *         1080 and bitrate can be up to 8.5 Mbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice
     *         is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: ""
     * (empty string, recording is disabled).
     * </p>
     * 
     * @return Recording-configuration ARN. A value other than an empty string indicates that recording is enabled.
     *         Default: "" (empty string, recording is disabled).
     */
    public final String recordingConfigurationArn() {
        return recordingConfigurationArn;
    }

    /**
     * <p>
     * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
     * </p>
     * 
     * @return Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming
     *         software.
     */
    public final String ingestEndpoint() {
        return ingestEndpoint;
    }

    /**
     * <p>
     * Channel playback URL.
     * </p>
     * 
     * @return Channel playback URL.
     */
    public final String playbackUrl() {
        return playbackUrl;
    }

    /**
     * <p>
     * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     */
    public final Boolean authorized() {
        return authorized;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(recordingConfigurationArn(), other.recordingConfigurationArn())
                && Objects.equals(ingestEndpoint(), other.ingestEndpoint()) && Objects.equals(playbackUrl(), other.playbackUrl())
                && Objects.equals(authorized(), other.authorized()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Channel").add("Arn", arn()).add("Name", name()).add("LatencyMode", latencyModeAsString())
                .add("Type", typeAsString()).add("RecordingConfigurationArn", recordingConfigurationArn())
                .add("IngestEndpoint", ingestEndpoint()).add("PlaybackUrl", playbackUrl()).add("Authorized", authorized())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "recordingConfigurationArn":
            return Optional.ofNullable(clazz.cast(recordingConfigurationArn()));
        case "ingestEndpoint":
            return Optional.ofNullable(clazz.cast(ingestEndpoint()));
        case "playbackUrl":
            return Optional.ofNullable(clazz.cast(playbackUrl()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * Channel ARN.
         * </p>
         * 
         * @param arn
         *        Channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon
         * IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
         *        Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
         *        respectively.)
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon
         * IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
         *        Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
         *        respectively.)
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         * viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080
         * and bitrate can be up to 8.5 Mbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is
         * limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give
         *        viewers the best experience for their devices and network conditions. Vertical resolution can be up to
         *        1080 and bitrate can be up to 8.5 Mbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality
         *        choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to
         *        1.5 Mbps.
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default:
         * "" (empty string, recording is disabled).
         * </p>
         * 
         * @param recordingConfigurationArn
         *        Recording-configuration ARN. A value other than an empty string indicates that recording is enabled.
         *        Default: "" (empty string, recording is disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurationArn(String recordingConfigurationArn);

        /**
         * <p>
         * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
         * </p>
         * 
         * @param ingestEndpoint
         *        Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming
         *        software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoint(String ingestEndpoint);

        /**
         * <p>
         * Channel playback URL.
         * </p>
         * 
         * @param playbackUrl
         *        Channel playback URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackUrl(String playbackUrl);

        /**
         * <p>
         * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * </p>
         * 
         * @param tags
         *        Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String latencyMode;

        private String type;

        private String recordingConfigurationArn;

        private String ingestEndpoint;

        private String playbackUrl;

        private Boolean authorized;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            arn(model.arn);
            name(model.name);
            latencyMode(model.latencyMode);
            type(model.type);
            recordingConfigurationArn(model.recordingConfigurationArn);
            ingestEndpoint(model.ingestEndpoint);
            playbackUrl(model.playbackUrl);
            authorized(model.authorized);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        @Transient
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        @Transient
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        @Transient
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final String getIngestEndpoint() {
            return ingestEndpoint;
        }

        public final void setIngestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
        }

        @Override
        @Transient
        public final Builder ingestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
            return this;
        }

        public final String getPlaybackUrl() {
            return playbackUrl;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        @Override
        @Transient
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        @Transient
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
