/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamKeysResponse extends IvsResponse implements
        ToCopyableBuilder<ListStreamKeysResponse.Builder, ListStreamKeysResponse> {
    private static final SdkField<List<StreamKeySummary>> STREAM_KEYS_FIELD = SdkField
            .<List<StreamKeySummary>> builder(MarshallingType.LIST)
            .memberName("streamKeys")
            .getter(getter(ListStreamKeysResponse::streamKeys))
            .setter(setter(Builder::streamKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamKeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamKeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_KEYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StreamKeySummary> streamKeys;

    private final String nextToken;

    private ListStreamKeysResponse(BuilderImpl builder) {
        super(builder);
        this.streamKeys = builder.streamKeys;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StreamKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStreamKeys() {
        return streamKeys != null && !(streamKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stream keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStreamKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of stream keys.
     */
    public final List<StreamKeySummary> streamKeys() {
        return streamKeys;
    }

    /**
     * <p>
     * If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
     * next set.
     * </p>
     * 
     * @return If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to
     *         get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamKeys() ? streamKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamKeysResponse)) {
            return false;
        }
        ListStreamKeysResponse other = (ListStreamKeysResponse) obj;
        return hasStreamKeys() == other.hasStreamKeys() && Objects.equals(streamKeys(), other.streamKeys())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamKeysResponse").add("StreamKeys", hasStreamKeys() ? streamKeys() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamKeys":
            return Optional.ofNullable(clazz.cast(streamKeys()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamKeysResponse, T> g) {
        return obj -> g.apply((ListStreamKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamKeysResponse> {
        /**
         * <p>
         * List of stream keys.
         * </p>
         * 
         * @param streamKeys
         *        List of stream keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(Collection<StreamKeySummary> streamKeys);

        /**
         * <p>
         * List of stream keys.
         * </p>
         * 
         * @param streamKeys
         *        List of stream keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKeys(StreamKeySummary... streamKeys);

        /**
         * <p>
         * List of stream keys.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamKeySummary>.Builder} avoiding the
         * need to create one manually via {@link List<StreamKeySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamKeySummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #streamKeys(List<StreamKeySummary>)}.
         * 
         * @param streamKeys
         *        a consumer that will call methods on {@link List<StreamKeySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamKeys(List<StreamKeySummary>)
         */
        Builder streamKeys(Consumer<StreamKeySummary.Builder>... streamKeys);

        /**
         * <p>
         * If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get
         * the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request
         *        to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<StreamKeySummary> streamKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamKeysResponse model) {
            super(model);
            streamKeys(model.streamKeys);
            nextToken(model.nextToken);
        }

        public final List<StreamKeySummary.Builder> getStreamKeys() {
            List<StreamKeySummary.Builder> result = StreamKeyListCopier.copyToBuilder(this.streamKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamKeys(Collection<StreamKeySummary.BuilderImpl> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copyFromBuilder(streamKeys);
        }

        @Override
        @Transient
        public final Builder streamKeys(Collection<StreamKeySummary> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copy(streamKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamKeys(StreamKeySummary... streamKeys) {
            streamKeys(Arrays.asList(streamKeys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamKeys(Consumer<StreamKeySummary.Builder>... streamKeys) {
            streamKeys(Stream.of(streamKeys).map(c -> StreamKeySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamKeysResponse build() {
            return new ListStreamKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
