/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration to record a channel stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RecordingConfiguration.Builder, RecordingConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RecordingConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(RecordingConfiguration::destinationConfiguration)).setter(setter(Builder::destinationConfiguration))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RecordingConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(RecordingConfiguration::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RecordingConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ThumbnailConfiguration> THUMBNAIL_CONFIGURATION_FIELD = SdkField
            .<ThumbnailConfiguration> builder(MarshallingType.SDK_POJO).memberName("thumbnailConfiguration")
            .getter(getter(RecordingConfiguration::thumbnailConfiguration)).setter(setter(Builder::thumbnailConfiguration))
            .constructor(ThumbnailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DESTINATION_CONFIGURATION_FIELD, NAME_FIELD, STATE_FIELD, TAGS_FIELD, THUMBNAIL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final DestinationConfiguration destinationConfiguration;

    private final String name;

    private final String state;

    private final Map<String, String> tags;

    private final ThumbnailConfiguration thumbnailConfiguration;

    private RecordingConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.name = builder.name;
        this.state = builder.state;
        this.tags = builder.tags;
        this.thumbnailConfiguration = builder.thumbnailConfiguration;
    }

    /**
     * <p>
     * Recording-configuration ARN.
     * </p>
     * 
     * @return Recording-configuration ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A complex type that contains information about where recorded video will be stored.
     * </p>
     * 
     * @return A complex type that contains information about where recorded video will be stored.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * <p>
     * Recording-configuration name. The value does not need to be unique.
     * </p>
     * 
     * @return Recording-configuration name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
     * configuration is ready for recording a channel stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RecordingConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
     *         configuration is ready for recording a channel stream.
     * @see RecordingConfigurationState
     */
    public final RecordingConfigurationState state() {
        return RecordingConfigurationState.fromValue(state);
    }

    /**
     * <p>
     * Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
     * configuration is ready for recording a channel stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RecordingConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
     *         configuration is ready for recording a channel stream.
     * @see RecordingConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the
     * interval at which thumbnails are generated for the live session.
     * </p>
     * 
     * @return A complex type that allows you to enable/disable the recording of thumbnails for a live session and
     *         modify the interval at which thumbnails are generated for the live session.
     */
    public final ThumbnailConfiguration thumbnailConfiguration() {
        return thumbnailConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingConfiguration)) {
            return false;
        }
        RecordingConfiguration other = (RecordingConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(destinationConfiguration(), other.destinationConfiguration())
                && Objects.equals(name(), other.name()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(thumbnailConfiguration(), other.thumbnailConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordingConfiguration").add("Arn", arn())
                .add("DestinationConfiguration", destinationConfiguration()).add("Name", name()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).add("ThumbnailConfiguration", thumbnailConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "thumbnailConfiguration":
            return Optional.ofNullable(clazz.cast(thumbnailConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordingConfiguration, T> g) {
        return obj -> g.apply((RecordingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordingConfiguration> {
        /**
         * <p>
         * Recording-configuration ARN.
         * </p>
         * 
         * @param arn
         *        Recording-configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A complex type that contains information about where recorded video will be stored.
         * </p>
         * 
         * @param destinationConfiguration
         *        A complex type that contains information about where recorded video will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * A complex type that contains information about where recorded video will be stored.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationConfiguration.Builder} avoiding the
         * need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * Recording-configuration name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Recording-configuration name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
         * configuration is ready for recording a channel stream.
         * </p>
         * 
         * @param state
         *        Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
         *        configuration is ready for recording a channel stream.
         * @see RecordingConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingConfigurationState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
         * configuration is ready for recording a channel stream.
         * </p>
         * 
         * @param state
         *        Indicates the current state of the recording configuration. When the state is <code>ACTIVE</code>, the
         *        configuration is ready for recording a channel stream.
         * @see RecordingConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingConfigurationState
         */
        Builder state(RecordingConfigurationState state);

        /**
         * <p>
         * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * </p>
         * 
         * @param tags
         *        Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify
         * the interval at which thumbnails are generated for the live session.
         * </p>
         * 
         * @param thumbnailConfiguration
         *        A complex type that allows you to enable/disable the recording of thumbnails for a live session and
         *        modify the interval at which thumbnails are generated for the live session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfiguration(ThumbnailConfiguration thumbnailConfiguration);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify
         * the interval at which thumbnails are generated for the live session.
         * </p>
         * This is a convenience that creates an instance of the {@link ThumbnailConfiguration.Builder} avoiding the
         * need to create one manually via {@link ThumbnailConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThumbnailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #thumbnailConfiguration(ThumbnailConfiguration)}.
         * 
         * @param thumbnailConfiguration
         *        a consumer that will call methods on {@link ThumbnailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfiguration(ThumbnailConfiguration)
         */
        default Builder thumbnailConfiguration(Consumer<ThumbnailConfiguration.Builder> thumbnailConfiguration) {
            return thumbnailConfiguration(ThumbnailConfiguration.builder().applyMutation(thumbnailConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private DestinationConfiguration destinationConfiguration;

        private String name;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ThumbnailConfiguration thumbnailConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingConfiguration model) {
            arn(model.arn);
            destinationConfiguration(model.destinationConfiguration);
            name(model.name);
            state(model.state);
            tags(model.tags);
            thumbnailConfiguration(model.thumbnailConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(RecordingConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final ThumbnailConfiguration.Builder getThumbnailConfiguration() {
            return thumbnailConfiguration != null ? thumbnailConfiguration.toBuilder() : null;
        }

        public final void setThumbnailConfiguration(ThumbnailConfiguration.BuilderImpl thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration != null ? thumbnailConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder thumbnailConfiguration(ThumbnailConfiguration thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        @Override
        public RecordingConfiguration build() {
            return new RecordingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
