/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a stream’s audio configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioConfiguration.Builder, AudioConfiguration> {
    private static final SdkField<Long> CHANNELS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("channels")
            .getter(getter(AudioConfiguration::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("codec")
            .getter(getter(AudioConfiguration::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<Long> SAMPLE_RATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("sampleRate").getter(getter(AudioConfiguration::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Long> TARGET_BITRATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("targetBitrate").getter(getter(AudioConfiguration::targetBitrate)).setter(setter(Builder::targetBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBitrate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CODEC_FIELD,
            SAMPLE_RATE_FIELD, TARGET_BITRATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long channels;

    private final String codec;

    private final Long sampleRate;

    private final Long targetBitrate;

    private AudioConfiguration(BuilderImpl builder) {
        this.channels = builder.channels;
        this.codec = builder.codec;
        this.sampleRate = builder.sampleRate;
        this.targetBitrate = builder.targetBitrate;
    }

    /**
     * <p>
     * Number of audio channels.
     * </p>
     * 
     * @return Number of audio channels.
     */
    public final Long channels() {
        return channels;
    }

    /**
     * <p>
     * Codec used for the audio encoding.
     * </p>
     * 
     * @return Codec used for the audio encoding.
     */
    public final String codec() {
        return codec;
    }

    /**
     * <p>
     * Number of audio samples recorded per second.
     * </p>
     * 
     * @return Number of audio samples recorded per second.
     */
    public final Long sampleRate() {
        return sampleRate;
    }

    /**
     * <p>
     * The expected ingest bitrate (bits per second). This is configured in the encoder.
     * </p>
     * 
     * @return The expected ingest bitrate (bits per second). This is configured in the encoder.
     */
    public final Long targetBitrate() {
        return targetBitrate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(targetBitrate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioConfiguration)) {
            return false;
        }
        AudioConfiguration other = (AudioConfiguration) obj;
        return Objects.equals(channels(), other.channels()) && Objects.equals(codec(), other.codec())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(targetBitrate(), other.targetBitrate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioConfiguration").add("Channels", channels()).add("Codec", codec())
                .add("SampleRate", sampleRate()).add("TargetBitrate", targetBitrate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "sampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "targetBitrate":
            return Optional.ofNullable(clazz.cast(targetBitrate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioConfiguration, T> g) {
        return obj -> g.apply((AudioConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioConfiguration> {
        /**
         * <p>
         * Number of audio channels.
         * </p>
         * 
         * @param channels
         *        Number of audio channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Long channels);

        /**
         * <p>
         * Codec used for the audio encoding.
         * </p>
         * 
         * @param codec
         *        Codec used for the audio encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * <p>
         * Number of audio samples recorded per second.
         * </p>
         * 
         * @param sampleRate
         *        Number of audio samples recorded per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Long sampleRate);

        /**
         * <p>
         * The expected ingest bitrate (bits per second). This is configured in the encoder.
         * </p>
         * 
         * @param targetBitrate
         *        The expected ingest bitrate (bits per second). This is configured in the encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBitrate(Long targetBitrate);
    }

    static final class BuilderImpl implements Builder {
        private Long channels;

        private String codec;

        private Long sampleRate;

        private Long targetBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioConfiguration model) {
            channels(model.channels);
            codec(model.codec);
            sampleRate(model.sampleRate);
            targetBitrate(model.targetBitrate);
        }

        public final Long getChannels() {
            return channels;
        }

        public final void setChannels(Long channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Long channels) {
            this.channels = channels;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Long getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Long getTargetBitrate() {
            return targetBitrate;
        }

        public final void setTargetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
        }

        @Override
        public final Builder targetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
            return this;
        }

        @Override
        public AudioConfiguration build() {
            return new AudioConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
