/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelSummary implements SdkPojo, Serializable, ToCopyableBuilder<ChannelSummary.Builder, ChannelSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ChannelSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(ChannelSummary::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(ChannelSummary::latencyModeAsString)).setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ChannelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingConfigurationArn").getter(getter(ChannelSummary::recordingConfigurationArn))
            .setter(setter(Builder::recordingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ChannelSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD,
            LATENCY_MODE_FIELD, NAME_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Boolean authorized;

    private final String latencyMode;

    private final String name;

    private final String recordingConfigurationArn;

    private final Map<String, String> tags;

    private ChannelSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Channel ARN.
     * </p>
     * 
     * @return Channel ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     */
    public final Boolean authorized() {
        return authorized;
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS
     * console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
     *         Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
     *         respectively.)
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon IVS
     * console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
     *         Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
     *         respectively.)
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default: ""
     * (empty string, recording is disabled).
     * </p>
     * 
     * @return Recording-configuration ARN. A value other than an empty string indicates that recording is enabled.
     *         Default: "" (empty string, recording is disabled).
     */
    public final String recordingConfigurationArn() {
        return recordingConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>
     * for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     * IVS has no service-specific constraints beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> for more information, including restrictions that apply to tags and
     *         "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
     *         documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSummary)) {
            return false;
        }
        ChannelSummary other = (ChannelSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(authorized(), other.authorized())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(recordingConfigurationArn(), other.recordingConfigurationArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelSummary").add("Arn", arn()).add("Authorized", authorized())
                .add("LatencyMode", latencyModeAsString()).add("Name", name())
                .add("RecordingConfigurationArn", recordingConfigurationArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recordingConfigurationArn":
            return Optional.ofNullable(clazz.cast(recordingConfigurationArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelSummary, T> g) {
        return obj -> g.apply((ChannelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelSummary> {
        /**
         * <p>
         * Channel ARN.
         * </p>
         * 
         * @param arn
         *        Channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon
         * IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
         *        Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
         *        respectively.)
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the Amazon
         * IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.)
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>. (Note: In the
         *        Amazon IVS console, <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard,
         *        respectively.)
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Recording-configuration ARN. A value other than an empty string indicates that recording is enabled. Default:
         * "" (empty string, recording is disabled).
         * </p>
         * 
         * @param recordingConfigurationArn
         *        Recording-configuration ARN. A value other than an empty string indicates that recording is enabled.
         *        Default: "" (empty string, recording is disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurationArn(String recordingConfigurationArn);

        /**
         * <p>
         * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> for more information, including restrictions that apply to tags and
         * "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> for more information, including restrictions that apply to tags and
         *        "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         *        documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Boolean authorized;

        private String latencyMode;

        private String name;

        private String recordingConfigurationArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSummary model) {
            arn(model.arn);
            authorized(model.authorized);
            latencyMode(model.latencyMode);
            name(model.name);
            recordingConfigurationArn(model.recordingConfigurationArn);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public ChannelSummary build() {
            return new ChannelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
