/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsRequest extends IvsRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private static final SdkField<StreamFilters> FILTER_BY_FIELD = SdkField.<StreamFilters> builder(MarshallingType.SDK_POJO)
            .memberName("filterBy").getter(getter(ListStreamsRequest::filterBy)).setter(setter(Builder::filterBy))
            .constructor(StreamFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListStreamsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final StreamFilters filterBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.filterBy = builder.filterBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Filters the stream list to match the specified criterion.
     * </p>
     * 
     * @return Filters the stream list to match the specified criterion.
     */
    public final StreamFilters filterBy() {
        return filterBy;
    }

    /**
     * <p>
     * Maximum number of streams to return. Default: 100.
     * </p>
     * 
     * @return Maximum number of streams to return. Default: 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     * </p>
     * 
     * @return The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        return Objects.equals(filterBy(), other.filterBy()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamsRequest").add("FilterBy", filterBy()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterBy":
            return Optional.ofNullable(clazz.cast(filterBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsRequest, T> g) {
        return obj -> g.apply((ListStreamsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * Filters the stream list to match the specified criterion.
         * </p>
         * 
         * @param filterBy
         *        Filters the stream list to match the specified criterion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBy(StreamFilters filterBy);

        /**
         * <p>
         * Filters the stream list to match the specified criterion.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamFilters.Builder} avoiding the need
         * to create one manually via {@link StreamFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filterBy(StreamFilters)}.
         * 
         * @param filterBy
         *        a consumer that will call methods on {@link StreamFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterBy(StreamFilters)
         */
        default Builder filterBy(Consumer<StreamFilters.Builder> filterBy) {
            return filterBy(StreamFilters.builder().applyMutation(filterBy).build());
        }

        /**
         * <p>
         * Maximum number of streams to return. Default: 100.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of streams to return. Default: 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.
         * </p>
         * 
         * @param nextToken
         *        The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private StreamFilters filterBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            super(model);
            filterBy(model.filterBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final StreamFilters.Builder getFilterBy() {
            return filterBy != null ? filterBy.toBuilder() : null;
        }

        public final void setFilterBy(StreamFilters.BuilderImpl filterBy) {
            this.filterBy = filterBy != null ? filterBy.build() : null;
        }

        @Override
        public final Builder filterBy(StreamFilters filterBy) {
            this.filterBy = filterBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
