/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelResponse extends IvsResponse implements
        ToCopyableBuilder<CreateChannelResponse.Builder, CreateChannelResponse> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.<Channel> builder(MarshallingType.SDK_POJO)
            .memberName("channel").getter(getter(CreateChannelResponse::channel)).setter(setter(Builder::channel))
            .constructor(Channel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<StreamKey> STREAM_KEY_FIELD = SdkField.<StreamKey> builder(MarshallingType.SDK_POJO)
            .memberName("streamKey").getter(getter(CreateChannelResponse::streamKey)).setter(setter(Builder::streamKey))
            .constructor(StreamKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            STREAM_KEY_FIELD));

    private final Channel channel;

    private final StreamKey streamKey;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.streamKey = builder.streamKey;
    }

    /**
     * Returns the value of the Channel property for this object.
     * 
     * @return The value of the Channel property for this object.
     */
    public final Channel channel() {
        return channel;
    }

    /**
     * Returns the value of the StreamKey property for this object.
     * 
     * @return The value of the StreamKey property for this object.
     */
    public final StreamKey streamKey() {
        return streamKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(streamKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse) obj;
        return Objects.equals(channel(), other.channel()) && Objects.equals(streamKey(), other.streamKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelResponse").add("Channel", channel()).add("StreamKey", streamKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "streamKey":
            return Optional.ofNullable(clazz.cast(streamKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelResponse> {
        /**
         * Sets the value of the Channel property for this object.
         *
         * @param channel
         *        The new value for the Channel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(Channel channel);

        /**
         * Sets the value of the Channel property for this object.
         *
         * This is a convenience that creates an instance of the {@link Channel.Builder} avoiding the need to create one
         * manually via {@link Channel#builder()}.
         *
         * When the {@link Consumer} completes, {@link Channel.Builder#build()} is called immediately and its result is
         * passed to {@link #channel(Channel)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link Channel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(Channel)
         */
        default Builder channel(Consumer<Channel.Builder> channel) {
            return channel(Channel.builder().applyMutation(channel).build());
        }

        /**
         * Sets the value of the StreamKey property for this object.
         *
         * @param streamKey
         *        The new value for the StreamKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKey(StreamKey streamKey);

        /**
         * Sets the value of the StreamKey property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamKey.Builder} avoiding the need to create
         * one manually via {@link StreamKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamKey.Builder#build()} is called immediately and its result
         * is passed to {@link #streamKey(StreamKey)}.
         * 
         * @param streamKey
         *        a consumer that will call methods on {@link StreamKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamKey(StreamKey)
         */
        default Builder streamKey(Consumer<StreamKey.Builder> streamKey) {
            return streamKey(StreamKey.builder().applyMutation(streamKey).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private Channel channel;

        private StreamKey streamKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            channel(model.channel);
            streamKey(model.streamKey);
        }

        public final Channel.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        public final StreamKey.Builder getStreamKey() {
            return streamKey != null ? streamKey.toBuilder() : null;
        }

        @Override
        public final Builder streamKey(StreamKey streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        public final void setStreamKey(StreamKey.BuilderImpl streamKey) {
            this.streamKey = streamKey != null ? streamKey.build() : null;
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
