/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelResponse extends IvsResponse implements
        ToCopyableBuilder<GetChannelResponse.Builder, GetChannelResponse> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.<Channel> builder(MarshallingType.SDK_POJO)
            .memberName("channel").getter(getter(GetChannelResponse::channel)).setter(setter(Builder::channel))
            .constructor(Channel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD));

    private final Channel channel;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Channel channel() {
        return channel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse) obj;
        return Objects.equals(channel(), other.channel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelResponse").add("Channel", channel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelResponse> {
        /**
         * <p/>
         * 
         * @param channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(Channel channel);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link Channel.Builder} avoiding the need to create one
         * manually via {@link Channel#builder()}.
         *
         * When the {@link Consumer} completes, {@link Channel.Builder#build()} is called immediately and its result is
         * passed to {@link #channel(Channel)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link Channel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(Channel)
         */
        default Builder channel(Consumer<Channel.Builder> channel) {
            return channel(Channel.builder().applyMutation(channel).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private Channel channel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            channel(model.channel);
        }

        public final Channel.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        @Transient
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
