/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternalServerException extends IvsException implements
        ToCopyableBuilder<InternalServerException.Builder, InternalServerException> {
    private static final SdkField<String> EXCEPTION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exceptionMessage").getter(getter(InternalServerException::exceptionMessage))
            .setter(setter(Builder::exceptionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exceptionMessage;

    private InternalServerException(BuilderImpl builder) {
        super(builder);
        this.exceptionMessage = builder.exceptionMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Unexpected error during processing of request.
     * </p>
     * 
     * @return Unexpected error during processing of request.
     */
    public String exceptionMessage() {
        return exceptionMessage;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InternalServerException, T> g) {
        return obj -> g.apply((InternalServerException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternalServerException>, IvsException.Builder {
        /**
         * <p>
         * Unexpected error during processing of request.
         * </p>
         * 
         * @param exceptionMessage
         *        Unexpected error during processing of request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionMessage(String exceptionMessage);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends IvsException.BuilderImpl implements Builder {
        private String exceptionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InternalServerException model) {
            super(model);
            exceptionMessage(model.exceptionMessage);
        }

        public final String getExceptionMessage() {
            return exceptionMessage;
        }

        @Override
        public final Builder exceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public final void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InternalServerException build() {
            return new InternalServerException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
