/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A viewer session to revoke in the call to <a>BatchStartViewerSessionRevocation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStartViewerSessionRevocationViewerSession implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchStartViewerSessionRevocationViewerSession.Builder, BatchStartViewerSessionRevocationViewerSession> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(BatchStartViewerSessionRevocationViewerSession::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> VIEWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("viewerId").getter(getter(BatchStartViewerSessionRevocationViewerSession::viewerId))
            .setter(setter(Builder::viewerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerId").build()).build();

    private static final SdkField<Integer> VIEWER_SESSION_VERSIONS_LESS_THAN_OR_EQUAL_TO_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("viewerSessionVersionsLessThanOrEqualTo")
            .getter(getter(BatchStartViewerSessionRevocationViewerSession::viewerSessionVersionsLessThanOrEqualTo))
            .setter(setter(Builder::viewerSessionVersionsLessThanOrEqualTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("viewerSessionVersionsLessThanOrEqualTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            VIEWER_ID_FIELD, VIEWER_SESSION_VERSIONS_LESS_THAN_OR_EQUAL_TO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String viewerId;

    private final Integer viewerSessionVersionsLessThanOrEqualTo;

    private BatchStartViewerSessionRevocationViewerSession(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.viewerId = builder.viewerId;
        this.viewerSessionVersionsLessThanOrEqualTo = builder.viewerSessionVersionsLessThanOrEqualTo;
    }

    /**
     * <p>
     * The ARN of the channel associated with the viewer session to revoke.
     * </p>
     * 
     * @return The ARN of the channel associated with the viewer session to revoke.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ID of the viewer associated with the viewer session to revoke. Do not use this field for personally
     * identifying, confidential, or sensitive information.
     * </p>
     * 
     * @return The ID of the viewer associated with the viewer session to revoke. Do not use this field for personally
     *         identifying, confidential, or sensitive information.
     */
    public final String viewerId() {
        return viewerId;
    }

    /**
     * <p>
     * An optional filter on which versions of the viewer session to revoke. All versions less than or equal to the
     * specified version will be revoked. Default: 0.
     * </p>
     * 
     * @return An optional filter on which versions of the viewer session to revoke. All versions less than or equal to
     *         the specified version will be revoked. Default: 0.
     */
    public final Integer viewerSessionVersionsLessThanOrEqualTo() {
        return viewerSessionVersionsLessThanOrEqualTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(viewerId());
        hashCode = 31 * hashCode + Objects.hashCode(viewerSessionVersionsLessThanOrEqualTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartViewerSessionRevocationViewerSession)) {
            return false;
        }
        BatchStartViewerSessionRevocationViewerSession other = (BatchStartViewerSessionRevocationViewerSession) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(viewerId(), other.viewerId())
                && Objects.equals(viewerSessionVersionsLessThanOrEqualTo(), other.viewerSessionVersionsLessThanOrEqualTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStartViewerSessionRevocationViewerSession").add("ChannelArn", channelArn())
                .add("ViewerId", viewerId())
                .add("ViewerSessionVersionsLessThanOrEqualTo", viewerSessionVersionsLessThanOrEqualTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "viewerId":
            return Optional.ofNullable(clazz.cast(viewerId()));
        case "viewerSessionVersionsLessThanOrEqualTo":
            return Optional.ofNullable(clazz.cast(viewerSessionVersionsLessThanOrEqualTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartViewerSessionRevocationViewerSession, T> g) {
        return obj -> g.apply((BatchStartViewerSessionRevocationViewerSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchStartViewerSessionRevocationViewerSession> {
        /**
         * <p>
         * The ARN of the channel associated with the viewer session to revoke.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel associated with the viewer session to revoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ID of the viewer associated with the viewer session to revoke. Do not use this field for personally
         * identifying, confidential, or sensitive information.
         * </p>
         * 
         * @param viewerId
         *        The ID of the viewer associated with the viewer session to revoke. Do not use this field for
         *        personally identifying, confidential, or sensitive information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerId(String viewerId);

        /**
         * <p>
         * An optional filter on which versions of the viewer session to revoke. All versions less than or equal to the
         * specified version will be revoked. Default: 0.
         * </p>
         * 
         * @param viewerSessionVersionsLessThanOrEqualTo
         *        An optional filter on which versions of the viewer session to revoke. All versions less than or equal
         *        to the specified version will be revoked. Default: 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerSessionVersionsLessThanOrEqualTo(Integer viewerSessionVersionsLessThanOrEqualTo);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String viewerId;

        private Integer viewerSessionVersionsLessThanOrEqualTo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartViewerSessionRevocationViewerSession model) {
            channelArn(model.channelArn);
            viewerId(model.viewerId);
            viewerSessionVersionsLessThanOrEqualTo(model.viewerSessionVersionsLessThanOrEqualTo);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getViewerId() {
            return viewerId;
        }

        public final void setViewerId(String viewerId) {
            this.viewerId = viewerId;
        }

        @Override
        public final Builder viewerId(String viewerId) {
            this.viewerId = viewerId;
            return this;
        }

        public final Integer getViewerSessionVersionsLessThanOrEqualTo() {
            return viewerSessionVersionsLessThanOrEqualTo;
        }

        public final void setViewerSessionVersionsLessThanOrEqualTo(Integer viewerSessionVersionsLessThanOrEqualTo) {
            this.viewerSessionVersionsLessThanOrEqualTo = viewerSessionVersionsLessThanOrEqualTo;
        }

        @Override
        public final Builder viewerSessionVersionsLessThanOrEqualTo(Integer viewerSessionVersionsLessThanOrEqualTo) {
            this.viewerSessionVersionsLessThanOrEqualTo = viewerSessionVersionsLessThanOrEqualTo;
            return this;
        }

        @Override
        public BatchStartViewerSessionRevocationViewerSession build() {
            return new BatchStartViewerSessionRevocationViewerSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
