/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends IvsRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(CreateChannelRequest::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureIngest").getter(getter(CreateChannelRequest::insecureIngest))
            .setter(setter(Builder::insecureIngest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(CreateChannelRequest::latencyModeAsString))
            .setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingConfigurationArn").getter(getter(CreateChannelRequest::recordingConfigurationArn))
            .setter(setter(Builder::recordingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateChannelRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_FIELD,
            INSECURE_INGEST_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final Boolean authorized;

    private final Boolean insecureIngest;

    private final String latencyMode;

    private final String name;

    private final String recordingConfigurationArn;

    private final Map<String, String> tags;

    private final String type;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.authorized = builder.authorized;
        this.insecureIngest = builder.insecureIngest;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     */
    public final Boolean authorized() {
        return authorized;
    }

    /**
     * <p>
     * Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
     */
    public final Boolean insecureIngest() {
        return insecureIngest;
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code>
     * and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
     *         <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
     *         <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console, <code>LOW</code>
     * and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
     *         <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
     *         <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Recording-configuration ARN. Default: "" (empty string, recording is disabled).
     * </p>
     * 
     * @return Recording-configuration ARN. Default: "" (empty string, recording is disabled).
     */
    public final String recordingConfigurationArn() {
        return recordingConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>
     * for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     * IVS has no service-specific constraints beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> for more information, including restrictions that apply to tags and
     *         "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
     *         documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
     * automatically give viewers the best experience for their devices and network conditions. Transcoding allows
     * higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to
     * 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through. This is
     * the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
     * video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5
     * Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
     *         automatically give viewers the best experience for their devices and network conditions. Transcoding
     *         allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and
     *         bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio
     *         is passed through. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
     *         video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be
     *         up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or
     * bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
     * automatically give viewers the best experience for their devices and network conditions. Transcoding allows
     * higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be up to
     * 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through. This is
     * the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
     * video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to 1.5
     * Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
     *         automatically give viewers the best experience for their devices and network conditions. Transcoding
     *         allows higher playback quality across a range of download speeds. Resolution can be up to 1080p and
     *         bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio
     *         is passed through. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
     *         video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be
     *         up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(authorized(), other.authorized()) && Objects.equals(insecureIngest(), other.insecureIngest())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(recordingConfigurationArn(), other.recordingConfigurationArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("Authorized", authorized()).add("InsecureIngest", insecureIngest())
                .add("LatencyMode", latencyModeAsString()).add("Name", name())
                .add("RecordingConfigurationArn", recordingConfigurationArn()).add("Tags", hasTags() ? tags() : null)
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "insecureIngest":
            return Optional.ofNullable(clazz.cast(insecureIngest()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recordingConfigurationArn":
            return Optional.ofNullable(clazz.cast(recordingConfigurationArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
         * </p>
         * 
         * @param insecureIngest
         *        Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureIngest(Boolean insecureIngest);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
         * <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
         * <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
         *        <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
         *        <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
         * <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
         * <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. (Note: In the Amazon IVS console,
         *        <code>LOW</code> and <code>NORMAL</code> correspond to Ultra-low and Standard, respectively.) Default:
         *        <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Recording-configuration ARN. Default: "" (empty string, recording is disabled).
         * </p>
         * 
         * @param recordingConfigurationArn
         *        Recording-configuration ARN. Default: "" (empty string, recording is disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurationArn(String recordingConfigurationArn);

        /**
         * <p>
         * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> for more information, including restrictions that apply to tags and
         * "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> for more information, including restrictions that apply to tags and
         *        "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         *        documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
         * automatically give viewers the best experience for their devices and network conditions. Transcoding allows
         * higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be
         * up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.
         * This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
         * video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to
         * 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input,
         *        to automatically give viewers the best experience for their devices and network conditions.
         *        Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to
         *        1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above
         *        that, audio is passed through. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The
         *        viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and
         *        bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input, to
         * automatically give viewers the best experience for their devices and network conditions. Transcoding allows
         * higher playback quality across a range of download speeds. Resolution can be up to 1080p and bitrate can be
         * up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.
         * This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The viewer’s
         * video-quality choice is limited to the original input. Resolution can be up to 1080p and bitrate can be up to
         * 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: Video is transcoded: multiple qualities are generated from the original input,
         *        to automatically give viewers the best experience for their devices and network conditions.
         *        Transcoding allows higher playback quality across a range of download speeds. Resolution can be up to
         *        1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above
         *        that, audio is passed through. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC</code>: Video is transmuxed: Amazon IVS delivers the original input to viewers. The
         *        viewer’s video-quality choice is limited to the original input. Resolution can be up to 1080p and
         *        bitrate can be up to 1.5 Mbps for 480p and up to 3.5 Mbps for resolutions between 480p and 1080p.
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private Boolean authorized;

        private Boolean insecureIngest;

        private String latencyMode;

        private String name;

        private String recordingConfigurationArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            authorized(model.authorized);
            insecureIngest(model.insecureIngest);
            latencyMode(model.latencyMode);
            name(model.name);
            recordingConfigurationArn(model.recordingConfigurationArn);
            tags(model.tags);
            type(model.type);
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final Boolean getInsecureIngest() {
            return insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
