/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse;

public class ListStreamKeysIterable
implements SdkIterable<ListStreamKeysResponse> {
    private final IvsClient client;
    private final ListStreamKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamKeysIterable(IvsClient client, ListStreamKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamKeysResponseFetcher();
    }

    public Iterator<ListStreamKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStreamKeysResponseFetcher
    implements SyncPageFetcher<ListStreamKeysResponse> {
        private ListStreamKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamKeysResponse nextPage(ListStreamKeysResponse previousPage) {
            if (previousPage == null) {
                return ListStreamKeysIterable.this.client.listStreamKeys(ListStreamKeysIterable.this.firstRequest);
            }
            return ListStreamKeysIterable.this.client.listStreamKeys((ListStreamKeysRequest)((Object)ListStreamKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

