/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends IvsRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateChannelRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(UpdateChannelRequest::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureIngest").getter(getter(UpdateChannelRequest::insecureIngest))
            .setter(setter(Builder::insecureIngest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(UpdateChannelRequest::latencyModeAsString))
            .setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLAYBACK_RESTRICTION_POLICY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("playbackRestrictionPolicyArn")
            .getter(getter(UpdateChannelRequest::playbackRestrictionPolicyArn))
            .setter(setter(Builder::playbackRestrictionPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackRestrictionPolicyArn")
                    .build()).build();

    private static final SdkField<String> PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("preset")
            .getter(getter(UpdateChannelRequest::presetAsString)).setter(setter(Builder::preset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()).build();

    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingConfigurationArn").getter(getter(UpdateChannelRequest::recordingConfigurationArn))
            .setter(setter(Builder::recordingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateChannelRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD,
            INSECURE_INGEST_FIELD, LATENCY_MODE_FIELD, NAME_FIELD, PLAYBACK_RESTRICTION_POLICY_ARN_FIELD, PRESET_FIELD,
            RECORDING_CONFIGURATION_ARN_FIELD, TYPE_FIELD));

    private final String arn;

    private final Boolean authorized;

    private final Boolean insecureIngest;

    private final String latencyMode;

    private final String name;

    private final String playbackRestrictionPolicyArn;

    private final String preset;

    private final String recordingConfigurationArn;

    private final String type;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.insecureIngest = builder.insecureIngest;
        this.latencyMode = builder.latencyMode;
        this.name = builder.name;
        this.playbackRestrictionPolicyArn = builder.playbackRestrictionPolicyArn;
        this.preset = builder.preset;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.type = builder.type;
    }

    /**
     * <p>
     * ARN of the channel to be updated.
     * </p>
     * 
     * @return ARN of the channel to be updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Whether the channel is private (enabled for playback authorization).
     * </p>
     * 
     * @return Whether the channel is private (enabled for playback authorization).
     */
    public final Boolean authorized() {
        return authorized;
    }

    /**
     * <p>
     * Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.
     */
    public final Boolean insecureIngest() {
        return insecureIngest;
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers.
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers.
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction.
     * If this is set to an empty string, playback restriction policy is disabled.
     * </p>
     * 
     * @return Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
     *         restriction. If this is set to an empty string, playback restriction policy is disabled.
     */
    public final String playbackRestrictionPolicyArn() {
        return playbackRestrictionPolicyArn;
    }

    /**
     * <p>
     * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>),
     * <code>preset</code> is the empty string (<code>""</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preset} will
     * return {@link TranscodePreset#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #presetAsString}.
     * </p>
     * 
     * @return Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     *         <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     *         <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
     *         <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
     * @see TranscodePreset
     */
    public final TranscodePreset preset() {
        return TranscodePreset.fromValue(preset);
    }

    /**
     * <p>
     * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>),
     * <code>preset</code> is the empty string (<code>""</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preset} will
     * return {@link TranscodePreset#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #presetAsString}.
     * </p>
     * 
     * @return Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     *         <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     *         <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
     *         <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
     * @see TranscodePreset
     */
    public final String presetAsString() {
        return preset;
    }

    /**
     * <p>
     * Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. If this is set
     * to an empty string, recording is disabled.
     * </p>
     * 
     * @return Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. If this
     *         is set to an empty string, recording is disabled.
     */
    public final String recordingConfigurationArn() {
        return recordingConfigurationArn;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For
     * details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     * Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. For details, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     *         Types</a>.
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For
     * details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     * Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. For details, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     *         Types</a>.
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackRestrictionPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(presetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(authorized(), other.authorized())
                && Objects.equals(insecureIngest(), other.insecureIngest())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(playbackRestrictionPolicyArn(), other.playbackRestrictionPolicyArn())
                && Objects.equals(presetAsString(), other.presetAsString())
                && Objects.equals(recordingConfigurationArn(), other.recordingConfigurationArn())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelRequest").add("Arn", arn()).add("Authorized", authorized())
                .add("InsecureIngest", insecureIngest()).add("LatencyMode", latencyModeAsString()).add("Name", name())
                .add("PlaybackRestrictionPolicyArn", playbackRestrictionPolicyArn()).add("Preset", presetAsString())
                .add("RecordingConfigurationArn", recordingConfigurationArn()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "insecureIngest":
            return Optional.ofNullable(clazz.cast(insecureIngest()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "playbackRestrictionPolicyArn":
            return Optional.ofNullable(clazz.cast(playbackRestrictionPolicyArn()));
        case "preset":
            return Optional.ofNullable(clazz.cast(presetAsString()));
        case "recordingConfigurationArn":
            return Optional.ofNullable(clazz.cast(recordingConfigurationArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * <p>
         * ARN of the channel to be updated.
         * </p>
         * 
         * @param arn
         *        ARN of the channel to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Whether the channel is private (enabled for playback authorization).
         * </p>
         * 
         * @param authorized
         *        Whether the channel is private (enabled for playback authorization).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.
         * </p>
         * 
         * @param insecureIngest
         *        Whether the channel allows insecure RTMP and SRT ingest. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureIngest(Boolean insecureIngest);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
         * restriction. If this is set to an empty string, playback restriction policy is disabled.
         * </p>
         * 
         * @param playbackRestrictionPolicyArn
         *        Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
         *        restriction. If this is set to an empty string, playback restriction policy is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackRestrictionPolicyArn(String playbackRestrictionPolicyArn);

        /**
         * <p>
         * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>
         * ), <code>preset</code> is the empty string (<code>""</code>).
         * </p>
         * 
         * @param preset
         *        Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         *        <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         *        <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
         *        <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
         * @see TranscodePreset
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscodePreset
         */
        Builder preset(String preset);

        /**
         * <p>
         * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>
         * ), <code>preset</code> is the empty string (<code>""</code>).
         * </p>
         * 
         * @param preset
         *        Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         *        <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         *        <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
         *        <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
         * @see TranscodePreset
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscodePreset
         */
        Builder preset(TranscodePreset preset);

        /**
         * <p>
         * Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. If this is
         * set to an empty string, recording is disabled.
         * </p>
         * 
         * @param recordingConfigurationArn
         *        Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. If
         *        this is set to an empty string, recording is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurationArn(String recordingConfigurationArn);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * For details, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        input resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. For details, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
         *        Types</a>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * For details, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        input resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. For details, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
         *        Types</a>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private String arn;

        private Boolean authorized;

        private Boolean insecureIngest;

        private String latencyMode;

        private String name;

        private String playbackRestrictionPolicyArn;

        private String preset;

        private String recordingConfigurationArn;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            arn(model.arn);
            authorized(model.authorized);
            insecureIngest(model.insecureIngest);
            latencyMode(model.latencyMode);
            name(model.name);
            playbackRestrictionPolicyArn(model.playbackRestrictionPolicyArn);
            preset(model.preset);
            recordingConfigurationArn(model.recordingConfigurationArn);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final Boolean getInsecureIngest() {
            return insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackRestrictionPolicyArn() {
            return playbackRestrictionPolicyArn;
        }

        public final void setPlaybackRestrictionPolicyArn(String playbackRestrictionPolicyArn) {
            this.playbackRestrictionPolicyArn = playbackRestrictionPolicyArn;
        }

        @Override
        public final Builder playbackRestrictionPolicyArn(String playbackRestrictionPolicyArn) {
            this.playbackRestrictionPolicyArn = playbackRestrictionPolicyArn;
            return this;
        }

        public final String getPreset() {
            return preset;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        @Override
        public final Builder preset(TranscodePreset preset) {
            this.preset(preset == null ? null : preset.toString());
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
