/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse;

public class ListStreamSessionsPublisher
implements SdkPublisher<ListStreamSessionsResponse> {
    private final IvsAsyncClient client;
    private final ListStreamSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamSessionsPublisher(IvsAsyncClient client, ListStreamSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamSessionsPublisher(IvsAsyncClient client, ListStreamSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStreamSessionsResponseFetcher
    implements AsyncPageFetcher<ListStreamSessionsResponse> {
        private ListStreamSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamSessionsResponse> nextPage(ListStreamSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamSessionsPublisher.this.client.listStreamSessions(ListStreamSessionsPublisher.this.firstRequest);
            }
            return ListStreamSessionsPublisher.this.client.listStreamSessions((ListStreamSessionsRequest)((Object)ListStreamSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

