/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamSummary implements SdkPojo, Serializable, ToCopyableBuilder<StreamSummary.Builder, StreamSummary> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(StreamSummary::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("health")
            .getter(getter(StreamSummary::healthAsString)).setter(setter(Builder::health))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(StreamSummary::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(StreamSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamId").getter(getter(StreamSummary::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<Long> VIEWER_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("viewerCount").getter(getter(StreamSummary::viewerCount)).setter(setter(Builder::viewerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            HEALTH_FIELD, START_TIME_FIELD, STATE_FIELD, STREAM_ID_FIELD, VIEWER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String health;

    private final Instant startTime;

    private final String state;

    private final String streamId;

    private final Long viewerCount;

    private StreamSummary(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.health = builder.health;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.streamId = builder.streamId;
        this.viewerCount = builder.viewerCount;
    }

    /**
     * <p>
     * Channel ARN for the stream.
     * </p>
     * 
     * @return Channel ARN for the stream.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public final StreamHealth health() {
        return StreamHealth.fromValue(health);
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public final String healthAsString() {
        return health;
    }

    /**
     * <p>
     * Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a
     * "NotBroadcasting" error will indicate that the stream is not live.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead,
     *         a "NotBroadcasting" error will indicate that the stream is not live.
     * @see StreamState
     */
    public final StreamState state() {
        return StreamState.fromValue(state);
    }

    /**
     * <p>
     * The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a
     * "NotBroadcasting" error will indicate that the stream is not live.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead,
     *         a "NotBroadcasting" error will indicate that the stream is not live.
     * @see StreamState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Unique identifier for a live or previously live stream in the specified channel.
     * </p>
     * 
     * @return Unique identifier for a live or previously live stream in the specified channel.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * <p>
     * A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within 15
     * seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute of when
     * video playback ends. A value of -1 indicates that the request timed out; in this case, retry.
     * </p>
     * 
     * @return A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code>
     *         within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code>
     *         within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in this
     *         case, retry.
     */
    public final Long viewerCount() {
        return viewerCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSummary)) {
            return false;
        }
        StreamSummary other = (StreamSummary) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(healthAsString(), other.healthAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(viewerCount(), other.viewerCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamSummary").add("ChannelArn", channelArn()).add("Health", healthAsString())
                .add("StartTime", startTime()).add("State", stateAsString()).add("StreamId", streamId())
                .add("ViewerCount", viewerCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "health":
            return Optional.ofNullable(clazz.cast(healthAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "viewerCount":
            return Optional.ofNullable(clazz.cast(viewerCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSummary, T> g) {
        return obj -> g.apply((StreamSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamSummary> {
        /**
         * <p>
         * Channel ARN for the stream.
         * </p>
         * 
         * @param channelArn
         *        Channel ARN for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(String health);

        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(StreamHealth health);

        /**
         * <p>
         * Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
         * </p>
         * 
         * @param startTime
         *        Time of the stream’s start. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a
         * "NotBroadcasting" error will indicate that the stream is not live.
         * </p>
         * 
         * @param state
         *        The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it;
         *        instead, a "NotBroadcasting" error will indicate that the stream is not live.
         * @see StreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamState
         */
        Builder state(String state);

        /**
         * <p>
         * The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it; instead, a
         * "NotBroadcasting" error will indicate that the stream is not live.
         * </p>
         * 
         * @param state
         *        The stream’s state. Do not rely on the <code>OFFLINE</code> state, as the API may not return it;
         *        instead, a "NotBroadcasting" error will indicate that the stream is not live.
         * @see StreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamState
         */
        Builder state(StreamState state);

        /**
         * <p>
         * Unique identifier for a live or previously live stream in the specified channel.
         * </p>
         * 
         * @param streamId
         *        Unique identifier for a live or previously live stream in the specified channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code> within
         * 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code> within 1 minute
         * of when video playback ends. A value of -1 indicates that the request timed out; in this case, retry.
         * </p>
         * 
         * @param viewerCount
         *        A count of concurrent views of the stream. Typically, a new view appears in <code>viewerCount</code>
         *        within 15 seconds of when video playback starts and a view is removed from <code>viewerCount</code>
         *        within 1 minute of when video playback ends. A value of -1 indicates that the request timed out; in
         *        this case, retry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCount(Long viewerCount);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String health;

        private Instant startTime;

        private String state;

        private String streamId;

        private Long viewerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSummary model) {
            channelArn(model.channelArn);
            health(model.health);
            startTime(model.startTime);
            state(model.state);
            streamId(model.streamId);
            viewerCount(model.viewerCount);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getHealth() {
            return health;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(StreamHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final Long getViewerCount() {
            return viewerCount;
        }

        public final void setViewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
        }

        @Override
        public final Builder viewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
            return this;
        }

        @Override
        public StreamSummary build() {
            return new StreamSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
