/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ivs.model.AccessDeniedException;
import software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest;
import software.amazon.awssdk.services.ivs.model.BatchGetChannelResponse;
import software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest;
import software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyResponse;
import software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest;
import software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse;
import software.amazon.awssdk.services.ivs.model.ChannelNotBroadcastingException;
import software.amazon.awssdk.services.ivs.model.ConflictException;
import software.amazon.awssdk.services.ivs.model.CreateChannelRequest;
import software.amazon.awssdk.services.ivs.model.CreateChannelResponse;
import software.amazon.awssdk.services.ivs.model.CreatePlaybackRestrictionPolicyRequest;
import software.amazon.awssdk.services.ivs.model.CreatePlaybackRestrictionPolicyResponse;
import software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest;
import software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse;
import software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest;
import software.amazon.awssdk.services.ivs.model.CreateStreamKeyResponse;
import software.amazon.awssdk.services.ivs.model.DeleteChannelRequest;
import software.amazon.awssdk.services.ivs.model.DeleteChannelResponse;
import software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest;
import software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairResponse;
import software.amazon.awssdk.services.ivs.model.DeletePlaybackRestrictionPolicyRequest;
import software.amazon.awssdk.services.ivs.model.DeletePlaybackRestrictionPolicyResponse;
import software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest;
import software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationResponse;
import software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest;
import software.amazon.awssdk.services.ivs.model.DeleteStreamKeyResponse;
import software.amazon.awssdk.services.ivs.model.GetChannelRequest;
import software.amazon.awssdk.services.ivs.model.GetChannelResponse;
import software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest;
import software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairResponse;
import software.amazon.awssdk.services.ivs.model.GetPlaybackRestrictionPolicyRequest;
import software.amazon.awssdk.services.ivs.model.GetPlaybackRestrictionPolicyResponse;
import software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest;
import software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationResponse;
import software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest;
import software.amazon.awssdk.services.ivs.model.GetStreamKeyResponse;
import software.amazon.awssdk.services.ivs.model.GetStreamRequest;
import software.amazon.awssdk.services.ivs.model.GetStreamResponse;
import software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest;
import software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse;
import software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest;
import software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairResponse;
import software.amazon.awssdk.services.ivs.model.InternalServerException;
import software.amazon.awssdk.services.ivs.model.IvsException;
import software.amazon.awssdk.services.ivs.model.ListChannelsRequest;
import software.amazon.awssdk.services.ivs.model.ListChannelsResponse;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesResponse;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse;
import software.amazon.awssdk.services.ivs.model.ListStreamsRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamsResponse;
import software.amazon.awssdk.services.ivs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ivs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ivs.model.PendingVerificationException;
import software.amazon.awssdk.services.ivs.model.PutMetadataRequest;
import software.amazon.awssdk.services.ivs.model.PutMetadataResponse;
import software.amazon.awssdk.services.ivs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ivs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest;
import software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationResponse;
import software.amazon.awssdk.services.ivs.model.StopStreamRequest;
import software.amazon.awssdk.services.ivs.model.StopStreamResponse;
import software.amazon.awssdk.services.ivs.model.StreamUnavailableException;
import software.amazon.awssdk.services.ivs.model.TagResourceRequest;
import software.amazon.awssdk.services.ivs.model.TagResourceResponse;
import software.amazon.awssdk.services.ivs.model.ThrottlingException;
import software.amazon.awssdk.services.ivs.model.UntagResourceRequest;
import software.amazon.awssdk.services.ivs.model.UntagResourceResponse;
import software.amazon.awssdk.services.ivs.model.UpdateChannelRequest;
import software.amazon.awssdk.services.ivs.model.UpdateChannelResponse;
import software.amazon.awssdk.services.ivs.model.UpdatePlaybackRestrictionPolicyRequest;
import software.amazon.awssdk.services.ivs.model.UpdatePlaybackRestrictionPolicyResponse;
import software.amazon.awssdk.services.ivs.model.ValidationException;
import software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable;
import software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable;
import software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable;
import software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable;
import software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable;
import software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable;

/**
 * Service client for accessing Amazon IVS. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <b>Introduction</b>
 * </p>
 * <p>
 * The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an Amazon Web
 * Services EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 * </p>
 * <p>
 * The API is an Amazon Web Services regional service. For a list of supported regions and Amazon IVS HTTPS service
 * endpoints, see the <a href="https://docs.aws.amazon.com/general/latest/gr/ivs.html">Amazon IVS page</a> in the
 * <i>Amazon Web Services General Reference</i>.
 * </p>
 * <p>
 * <i> <b>All API request parameters and URLs are case sensitive. </b> </i>
 * </p>
 * <p>
 * For a summary of notable documentation changes in each release, see <a
 * href="https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html"> Document History</a>.
 * </p>
 * <p>
 * <b>Allowed Header Values</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code> <b>Accept:</b> </code> application/json
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> <b>Accept-Encoding:</b> </code> gzip, deflate
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> <b>Content-Type:</b> </code>application/json
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Key Concepts</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Channel</b> — Stores configuration data related to your live stream. You first create a channel and then use the
 * channel’s stream key to start your live stream.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Stream key</b> — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize
 * streaming. <i> <b>Treat the stream key like a secret, since it allows anyone to stream to the channel.</b> </i>
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Playback key pair</b> — Video playback may be restricted using playback-authorization tokens, which use public-key
 * encryption. A playback key pair is the public-private pair of keys used to sign and validate the
 * playback-authorization token.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Recording configuration</b> — Stores configuration related to recording a live stream and where to store the
 * recorded content. Multiple channels can reference the same recording configuration.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Playback restriction policy</b> — Restricts playback by countries and/or origin sites.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about your IVS live stream, also see <a
 * href="https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/getting-started.html">Getting Started with IVS
 * Low-Latency Streaming</a>.
 * </p>
 * <p>
 * <b>Tagging</b>
 * </p>
 * <p>
 * A <i>tag</i> is a metadata label that you assign to an Amazon Web Services resource. A tag comprises a <i>key</i> and
 * a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular
 * video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
 * Services Resources</a> for more information, including restrictions that apply to tags and
 * "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented there.
 * </p>
 * <p>
 * Tags can help you identify and organize your Amazon Web Services resources. For example, you can use the same tag for
 * different resources to indicate that they are related. You can also use tags to manage access (see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html"> Access Tags</a>).
 * </p>
 * <p>
 * The Amazon IVS API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and
 * <a>ListTagsForResource</a>. The following resources support tagging: Channels, Stream Keys, Playback Key Pairs, and
 * Recording Configurations.
 * </p>
 * <p>
 * At most 50 tags can be applied to a resource.
 * </p>
 * <p>
 * <b>Authentication versus Authorization</b>
 * </p>
 * <p>
 * Note the differences between these concepts:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>Authentication</i> is about verifying identity. You need to be authenticated to sign Amazon IVS API requests.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>Authorization</i> is about granting permissions. Your IAM roles need to have permissions for Amazon IVS API
 * requests. In addition, authorization is needed to view <a
 * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Amazon IVS private channels</a>.
 * (Private channels are channels that are enabled for "playback authorization.")
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Authentication</b>
 * </p>
 * <p>
 * All Amazon IVS API requests must be authenticated with a signature. The Amazon Web Services Command-Line Interface
 * (CLI) and Amazon IVS Player SDKs take care of signing the underlying API calls for you. However, if your application
 * calls the Amazon IVS API directly, it’s your responsibility to sign the requests.
 * </p>
 * <p>
 * You generate a signature using valid Amazon Web Services credentials that have permission to perform the requested
 * action. For example, you must sign PutMetadata requests with a signature generated from a user account that has the
 * <code>ivs:PutMetadata</code> permission.
 * </p>
 * <p>
 * For more information:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Authentication and generating signatures — See <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests
 * (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Web Services General Reference</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Managing Amazon IVS permissions — See <a
 * href="https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html">Identity and Access Management</a> on the
 * Security page of the <i>Amazon IVS User Guide</i>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Amazon Resource Names (ARNs)</b>
 * </p>
 * <p>
 * ARNs uniquely identify AWS resources. An ARN is required when you need to specify a resource unambiguously across all
 * of AWS, such as in IAM policies and API calls. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names</a> in the
 * <i>AWS General Reference</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IvsClient extends AwsClient {
    String SERVICE_NAME = "ivs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ivs";

    /**
     * <p>
     * Performs <a>GetChannel</a> on multiple ARNs simultaneously.
     * </p>
     *
     * @param batchGetChannelRequest
     * @return Result of the BatchGetChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchGetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetChannelResponse batchGetChannel(BatchGetChannelRequest batchGetChannelRequest) throws AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs <a>GetChannel</a> on multiple ARNs simultaneously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetChannelRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetChannelRequest#builder()}
     * </p>
     *
     * @param batchGetChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.BatchGetChannelRequest.Builder} to create a request.
     * @return Result of the BatchGetChannel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchGetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetChannelResponse batchGetChannel(Consumer<BatchGetChannelRequest.Builder> batchGetChannelRequest)
            throws AwsServiceException, SdkClientException, IvsException {
        return batchGetChannel(BatchGetChannelRequest.builder().applyMutation(batchGetChannelRequest).build());
    }

    /**
     * <p>
     * Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.
     * </p>
     *
     * @param batchGetStreamKeyRequest
     * @return Result of the BatchGetStreamKey operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchGetStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetStreamKeyResponse batchGetStreamKey(BatchGetStreamKeyRequest batchGetStreamKeyRequest)
            throws AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetStreamKeyRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetStreamKeyRequest#builder()}
     * </p>
     *
     * @param batchGetStreamKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.BatchGetStreamKeyRequest.Builder} to create a request.
     * @return Result of the BatchGetStreamKey operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchGetStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchGetStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetStreamKeyResponse batchGetStreamKey(Consumer<BatchGetStreamKeyRequest.Builder> batchGetStreamKeyRequest)
            throws AwsServiceException, SdkClientException, IvsException {
        return batchGetStreamKey(BatchGetStreamKeyRequest.builder().applyMutation(batchGetStreamKeyRequest).build());
    }

    /**
     * <p>
     * Performs <a>StartViewerSessionRevocation</a> on multiple channel ARN and viewer ID pairs simultaneously.
     * </p>
     *
     * @param batchStartViewerSessionRevocationRequest
     * @return Result of the BatchStartViewerSessionRevocation operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchStartViewerSessionRevocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchStartViewerSessionRevocation"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchStartViewerSessionRevocationResponse batchStartViewerSessionRevocation(
            BatchStartViewerSessionRevocationRequest batchStartViewerSessionRevocationRequest) throws AccessDeniedException,
            ValidationException, PendingVerificationException, ThrottlingException, AwsServiceException, SdkClientException,
            IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs <a>StartViewerSessionRevocation</a> on multiple channel ARN and viewer ID pairs simultaneously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStartViewerSessionRevocationRequest.Builder}
     * avoiding the need to create one manually via {@link BatchStartViewerSessionRevocationRequest#builder()}
     * </p>
     *
     * @param batchStartViewerSessionRevocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest.Builder} to
     *        create a request.
     * @return Result of the BatchStartViewerSessionRevocation operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.BatchStartViewerSessionRevocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/BatchStartViewerSessionRevocation"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchStartViewerSessionRevocationResponse batchStartViewerSessionRevocation(
            Consumer<BatchStartViewerSessionRevocationRequest.Builder> batchStartViewerSessionRevocationRequest)
            throws AccessDeniedException, ValidationException, PendingVerificationException, ThrottlingException,
            AwsServiceException, SdkClientException, IvsException {
        return batchStartViewerSessionRevocation(BatchStartViewerSessionRevocationRequest.builder()
                .applyMutation(batchStartViewerSessionRevocationRequest).build());
    }

    /**
     * <p>
     * Creates a new channel and an associated stream key to start streaming.
     * </p>
     *
     * @param createChannelRequest
     * @return Result of the CreateChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new channel and an associated stream key to start streaming.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.CreateChannelRequest.Builder} to create a request.
     * @return Result of the CreateChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * <p>
     * Creates a new playback restriction policy, for constraining playback by countries and/or origins.
     * </p>
     *
     * @param createPlaybackRestrictionPolicyRequest
     * @return Result of the CreatePlaybackRestrictionPolicy operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreatePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreatePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlaybackRestrictionPolicyResponse createPlaybackRestrictionPolicy(
            CreatePlaybackRestrictionPolicyRequest createPlaybackRestrictionPolicyRequest) throws AccessDeniedException,
            ValidationException, PendingVerificationException, ThrottlingException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new playback restriction policy, for constraining playback by countries and/or origins.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlaybackRestrictionPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePlaybackRestrictionPolicyRequest#builder()}
     * </p>
     *
     * @param createPlaybackRestrictionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.CreatePlaybackRestrictionPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePlaybackRestrictionPolicy operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreatePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreatePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlaybackRestrictionPolicyResponse createPlaybackRestrictionPolicy(
            Consumer<CreatePlaybackRestrictionPolicyRequest.Builder> createPlaybackRestrictionPolicyRequest)
            throws AccessDeniedException, ValidationException, PendingVerificationException, ThrottlingException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        return createPlaybackRestrictionPolicy(CreatePlaybackRestrictionPolicyRequest.builder()
                .applyMutation(createPlaybackRestrictionPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new recording configuration, used to enable recording to Amazon S3.
     * </p>
     * <p>
     * <b>Known issue:</b> In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording
     * configuration, it returns success even if the S3 bucket is in a different region. In this case, the
     * <code>state</code> of the recording configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>).
     * (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
     * </p>
     * <p>
     * <b>Workaround:</b> Ensure that your S3 bucket is in the same region as the recording configuration. If you create
     * a recording configuration in a different region as your S3 bucket, delete that recording configuration and create
     * a new one with an S3 bucket from the correct region.
     * </p>
     *
     * @param createRecordingConfigurationRequest
     * @return Result of the CreateRecordingConfiguration operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateRecordingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRecordingConfigurationResponse createRecordingConfiguration(
            CreateRecordingConfigurationRequest createRecordingConfigurationRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, PendingVerificationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new recording configuration, used to enable recording to Amazon S3.
     * </p>
     * <p>
     * <b>Known issue:</b> In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording
     * configuration, it returns success even if the S3 bucket is in a different region. In this case, the
     * <code>state</code> of the recording configuration is <code>CREATE_FAILED</code> (instead of <code>ACTIVE</code>).
     * (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
     * </p>
     * <p>
     * <b>Workaround:</b> Ensure that your S3 bucket is in the same region as the recording configuration. If you create
     * a recording configuration in a different region as your S3 bucket, delete that recording configuration and create
     * a new one with an S3 bucket from the correct region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecordingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRecordingConfigurationRequest#builder()}
     * </p>
     *
     * @param createRecordingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRecordingConfiguration operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateRecordingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRecordingConfigurationResponse createRecordingConfiguration(
            Consumer<CreateRecordingConfigurationRequest.Builder> createRecordingConfigurationRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, PendingVerificationException,
            ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        return createRecordingConfiguration(CreateRecordingConfigurationRequest.builder()
                .applyMutation(createRecordingConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a stream key, used to initiate a stream, for the specified channel ARN.
     * </p>
     * <p>
     * Note that <a>CreateChannel</a> creates a stream key. If you subsequently use CreateStreamKey on the same channel,
     * it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the
     * stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.
     * </p>
     *
     * @param createStreamKeyRequest
     * @return Result of the CreateStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStreamKeyResponse createStreamKey(CreateStreamKeyRequest createStreamKeyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stream key, used to initiate a stream, for the specified channel ARN.
     * </p>
     * <p>
     * Note that <a>CreateChannel</a> creates a stream key. If you subsequently use CreateStreamKey on the same channel,
     * it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the
     * stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateStreamKeyRequest#builder()}
     * </p>
     *
     * @param createStreamKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest.Builder} to create a request.
     * @return Result of the CreateStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.CreateStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/CreateStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStreamKeyResponse createStreamKey(Consumer<CreateStreamKeyRequest.Builder> createStreamKeyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        return createStreamKey(CreateStreamKeyRequest.builder().applyMutation(createStreamKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified channel and its associated stream keys.
     * </p>
     * <p>
     * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is
     * live, call <a>StopStream</a>, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's
     * state is no longer Live), then call DeleteChannel. (See <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.)
     * </p>
     *
     * @param deleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, ConflictException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified channel and its associated stream keys.
     * </p>
     * <p>
     * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is
     * live, call <a>StopStream</a>, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's
     * state is no longer Live), then call DeleteChannel. (See <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html"> Using EventBridge with Amazon IVS</a>.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.DeleteChannelRequest.Builder} to create a request.
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ConflictException, AwsServiceException, SdkClientException, IvsException {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s
     * <code>privateKey</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     *
     * @param deletePlaybackKeyPairRequest
     * @return Result of the DeletePlaybackKeyPair operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeletePlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlaybackKeyPairResponse deletePlaybackKeyPair(DeletePlaybackKeyPairRequest deletePlaybackKeyPairRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s
     * <code>privateKey</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaybackKeyPairRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePlaybackKeyPairRequest#builder()}
     * </p>
     *
     * @param deletePlaybackKeyPairRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.DeletePlaybackKeyPairRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePlaybackKeyPair operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeletePlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlaybackKeyPairResponse deletePlaybackKeyPair(
            Consumer<DeletePlaybackKeyPairRequest.Builder> deletePlaybackKeyPairRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, AwsServiceException, SdkClientException,
            IvsException {
        return deletePlaybackKeyPair(DeletePlaybackKeyPairRequest.builder().applyMutation(deletePlaybackKeyPairRequest).build());
    }

    /**
     * <p>
     * Deletes the specified playback restriction policy.
     * </p>
     *
     * @param deletePlaybackRestrictionPolicyRequest
     * @return Result of the DeletePlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeletePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackRestrictionPolicyResponse deletePlaybackRestrictionPolicy(
            DeletePlaybackRestrictionPolicyRequest deletePlaybackRestrictionPolicyRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, ConflictException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified playback restriction policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlaybackRestrictionPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePlaybackRestrictionPolicyRequest#builder()}
     * </p>
     *
     * @param deletePlaybackRestrictionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.DeletePlaybackRestrictionPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeletePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeletePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlaybackRestrictionPolicyResponse deletePlaybackRestrictionPolicy(
            Consumer<DeletePlaybackRestrictionPolicyRequest.Builder> deletePlaybackRestrictionPolicyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ConflictException, AwsServiceException, SdkClientException, IvsException {
        return deletePlaybackRestrictionPolicy(DeletePlaybackRestrictionPolicyRequest.builder()
                .applyMutation(deletePlaybackRestrictionPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the recording configuration for the specified ARN.
     * </p>
     * <p>
     * If you try to delete a recording configuration that is associated with a channel, you will get an error (409
     * ConflictException). To avoid this, for all channels that reference the recording configuration, first use
     * <a>UpdateChannel</a> to set the <code>recordingConfigurationArn</code> field to an empty string, then use
     * DeleteRecordingConfiguration.
     * </p>
     *
     * @param deleteRecordingConfigurationRequest
     * @return Result of the DeleteRecordingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteRecordingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRecordingConfigurationResponse deleteRecordingConfiguration(
            DeleteRecordingConfigurationRequest deleteRecordingConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recording configuration for the specified ARN.
     * </p>
     * <p>
     * If you try to delete a recording configuration that is associated with a channel, you will get an error (409
     * ConflictException). To avoid this, for all channels that reference the recording configuration, first use
     * <a>UpdateChannel</a> to set the <code>recordingConfigurationArn</code> field to an empty string, then use
     * DeleteRecordingConfiguration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecordingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRecordingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRecordingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRecordingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteRecordingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRecordingConfigurationResponse deleteRecordingConfiguration(
            Consumer<DeleteRecordingConfigurationRequest.Builder> deleteRecordingConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            ConflictException, AwsServiceException, SdkClientException, IvsException {
        return deleteRecordingConfiguration(DeleteRecordingConfigurationRequest.builder()
                .applyMutation(deleteRecordingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
     * </p>
     *
     * @param deleteStreamKeyRequest
     * @return Result of the DeleteStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStreamKeyResponse deleteStreamKey(DeleteStreamKeyRequest deleteStreamKeyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteStreamKeyRequest#builder()}
     * </p>
     *
     * @param deleteStreamKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.DeleteStreamKeyRequest.Builder} to create a request.
     * @return Result of the DeleteStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.DeleteStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/DeleteStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStreamKeyResponse deleteStreamKey(Consumer<DeleteStreamKeyRequest.Builder> deleteStreamKeyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            AwsServiceException, SdkClientException, IvsException {
        return deleteStreamKey(DeleteStreamKeyRequest.builder().applyMutation(deleteStreamKeyRequest).build());
    }

    /**
     * <p>
     * Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.
     * </p>
     *
     * @param getChannelRequest
     * @return Result of the GetChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetChannelRequest.Builder} to create a request.
     * @return Result of the GetChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetChannelResponse getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>.
     * The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant
     * viewers access to private channels. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     *
     * @param getPlaybackKeyPairRequest
     * @return Result of the GetPlaybackKeyPair operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetPlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlaybackKeyPairResponse getPlaybackKeyPair(GetPlaybackKeyPairRequest getPlaybackKeyPairRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a specified playback authorization key pair and returns the <code>arn</code> and <code>fingerprint</code>.
     * The <code>privateKey</code> held by the caller can be used to generate viewer authorization tokens, to grant
     * viewers access to private channels. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaybackKeyPairRequest.Builder} avoiding the
     * need to create one manually via {@link GetPlaybackKeyPairRequest#builder()}
     * </p>
     *
     * @param getPlaybackKeyPairRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetPlaybackKeyPairRequest.Builder} to create a request.
     * @return Result of the GetPlaybackKeyPair operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetPlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPlaybackKeyPairResponse getPlaybackKeyPair(Consumer<GetPlaybackKeyPairRequest.Builder> getPlaybackKeyPairRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return getPlaybackKeyPair(GetPlaybackKeyPairRequest.builder().applyMutation(getPlaybackKeyPairRequest).build());
    }

    /**
     * <p>
     * Gets the specified playback restriction policy.
     * </p>
     *
     * @param getPlaybackRestrictionPolicyRequest
     * @return Result of the GetPlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetPlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackRestrictionPolicyResponse getPlaybackRestrictionPolicy(
            GetPlaybackRestrictionPolicyRequest getPlaybackRestrictionPolicyRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, AwsServiceException, SdkClientException,
            IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified playback restriction policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlaybackRestrictionPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetPlaybackRestrictionPolicyRequest#builder()}
     * </p>
     *
     * @param getPlaybackRestrictionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetPlaybackRestrictionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetPlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetPlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetPlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlaybackRestrictionPolicyResponse getPlaybackRestrictionPolicy(
            Consumer<GetPlaybackRestrictionPolicyRequest.Builder> getPlaybackRestrictionPolicyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            AwsServiceException, SdkClientException, IvsException {
        return getPlaybackRestrictionPolicy(GetPlaybackRestrictionPolicyRequest.builder()
                .applyMutation(getPlaybackRestrictionPolicyRequest).build());
    }

    /**
     * <p>
     * Gets the recording configuration for the specified ARN.
     * </p>
     *
     * @param getRecordingConfigurationRequest
     * @return Result of the GetRecordingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetRecordingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRecordingConfigurationResponse getRecordingConfiguration(
            GetRecordingConfigurationRequest getRecordingConfigurationRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the recording configuration for the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecordingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetRecordingConfigurationRequest#builder()}
     * </p>
     *
     * @param getRecordingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetRecordingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetRecordingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetRecordingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetRecordingConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetRecordingConfigurationResponse getRecordingConfiguration(
            Consumer<GetRecordingConfigurationRequest.Builder> getRecordingConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            AwsServiceException, SdkClientException, IvsException {
        return getRecordingConfiguration(GetRecordingConfigurationRequest.builder()
                .applyMutation(getRecordingConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about the active (live) stream on a specified channel.
     * </p>
     *
     * @param getStreamRequest
     * @return Result of the GetStream operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamResponse getStream(GetStreamRequest getStreamRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, ChannelNotBroadcastingException, AwsServiceException, SdkClientException,
            IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the active (live) stream on a specified channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamRequest.Builder} avoiding the need to
     * create one manually via {@link GetStreamRequest#builder()}
     * </p>
     *
     * @param getStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetStreamRequest.Builder} to create a request.
     * @return Result of the GetStream operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStream" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamResponse getStream(Consumer<GetStreamRequest.Builder> getStreamRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, ChannelNotBroadcastingException, AwsServiceException, SdkClientException,
            IvsException {
        return getStream(GetStreamRequest.builder().applyMutation(getStreamRequest).build());
    }

    /**
     * <p>
     * Gets stream-key information for a specified ARN.
     * </p>
     *
     * @param getStreamKeyRequest
     * @return Result of the GetStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamKeyResponse getStreamKey(GetStreamKeyRequest getStreamKeyRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets stream-key information for a specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetStreamKeyRequest#builder()}
     * </p>
     *
     * @param getStreamKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest.Builder} to create a request.
     * @return Result of the GetStreamKey operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStreamKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamKeyResponse getStreamKey(Consumer<GetStreamKeyRequest.Builder> getStreamKeyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return getStreamKey(GetStreamKeyRequest.builder().applyMutation(getStreamKeyRequest).build());
    }

    /**
     * <p>
     * Gets metadata on a specified stream.
     * </p>
     *
     * @param getStreamSessionRequest
     * @return Result of the GetStreamSession operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamSessionResponse getStreamSession(GetStreamSessionRequest getStreamSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata on a specified stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetStreamSessionRequest#builder()}
     * </p>
     *
     * @param getStreamSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest.Builder} to create a request.
     * @return Result of the GetStreamSession operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.GetStreamSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/GetStreamSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStreamSessionResponse getStreamSession(Consumer<GetStreamSessionRequest.Builder> getStreamSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return getStreamSession(GetStreamSessionRequest.builder().applyMutation(getStreamSessionRequest).build());
    }

    /**
     * <p>
     * Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The
     * <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to
     * private channels. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     *
     * @param importPlaybackKeyPairRequest
     * @return Result of the ImportPlaybackKeyPair operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ImportPlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportPlaybackKeyPairResponse importPlaybackKeyPair(ImportPlaybackKeyPairRequest importPlaybackKeyPairRequest)
            throws AccessDeniedException, ValidationException, PendingVerificationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the public portion of a new key pair and returns its <code>arn</code> and <code>fingerprint</code>. The
     * <code>privateKey</code> can then be used to generate viewer authorization tokens, to grant viewers access to
     * private channels. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportPlaybackKeyPairRequest.Builder} avoiding the
     * need to create one manually via {@link ImportPlaybackKeyPairRequest#builder()}
     * </p>
     *
     * @param importPlaybackKeyPairRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ImportPlaybackKeyPairRequest.Builder} to create a
     *        request.
     * @return Result of the ImportPlaybackKeyPair operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws ServiceQuotaExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ImportPlaybackKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ImportPlaybackKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportPlaybackKeyPairResponse importPlaybackKeyPair(
            Consumer<ImportPlaybackKeyPairRequest.Builder> importPlaybackKeyPairRequest) throws AccessDeniedException,
            ValidationException, PendingVerificationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IvsException {
        return importPlaybackKeyPair(ImportPlaybackKeyPairRequest.builder().applyMutation(importPlaybackKeyPairRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all channels in your account, in the Amazon Web Services region where the API
     * request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters
     * are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409
     * ConflictException).
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws AccessDeniedException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all channels in your account, in the Amazon Web Services region where the API
     * request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters
     * are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409
     * ConflictException).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListChannelsRequest.Builder} to create a request.
     * @return Result of the ListChannels operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            IvsException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.ivs.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.ivs.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws AccessDeniedException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, IvsException {
        return new ListChannelsIterable(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.ivs.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.ivs.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListChannelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            IvsException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about playback key pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     *
     * @param listPlaybackKeyPairsRequest
     * @return Result of the ListPlaybackKeyPairs operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackKeyPairs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaybackKeyPairsResponse listPlaybackKeyPairs(ListPlaybackKeyPairsRequest listPlaybackKeyPairsRequest)
            throws AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about playback key pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a> in
     * the <i>Amazon IVS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackKeyPairsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlaybackKeyPairsRequest#builder()}
     * </p>
     *
     * @param listPlaybackKeyPairsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest.Builder} to create a request.
     * @return Result of the ListPlaybackKeyPairs operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackKeyPairs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaybackKeyPairsResponse listPlaybackKeyPairs(
            Consumer<ListPlaybackKeyPairsRequest.Builder> listPlaybackKeyPairsRequest) throws AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listPlaybackKeyPairs(ListPlaybackKeyPairsRequest.builder().applyMutation(listPlaybackKeyPairsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackKeyPairs(software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client.listPlaybackKeyPairsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client
     *             .listPlaybackKeyPairsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client.listPlaybackKeyPairsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackKeyPairs(software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlaybackKeyPairsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackKeyPairs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaybackKeyPairsIterable listPlaybackKeyPairsPaginator(ListPlaybackKeyPairsRequest listPlaybackKeyPairsRequest)
            throws AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return new ListPlaybackKeyPairsIterable(this, listPlaybackKeyPairsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackKeyPairs(software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client.listPlaybackKeyPairsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client
     *             .listPlaybackKeyPairsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackKeyPairsIterable responses = client.listPlaybackKeyPairsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackKeyPairs(software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackKeyPairsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPlaybackKeyPairsRequest#builder()}
     * </p>
     *
     * @param listPlaybackKeyPairsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackKeyPairs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPlaybackKeyPairsIterable listPlaybackKeyPairsPaginator(
            Consumer<ListPlaybackKeyPairsRequest.Builder> listPlaybackKeyPairsRequest) throws AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listPlaybackKeyPairsPaginator(ListPlaybackKeyPairsRequest.builder().applyMutation(listPlaybackKeyPairsRequest)
                .build());
    }

    /**
     * <p>
     * Gets summary information about playback restriction policies.
     * </p>
     *
     * @param listPlaybackRestrictionPoliciesRequest
     * @return Result of the ListPlaybackRestrictionPolicies operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackRestrictionPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackRestrictionPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackRestrictionPoliciesResponse listPlaybackRestrictionPolicies(
            ListPlaybackRestrictionPoliciesRequest listPlaybackRestrictionPoliciesRequest) throws AccessDeniedException,
            ValidationException, PendingVerificationException, ConflictException, AwsServiceException, SdkClientException,
            IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about playback restriction policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackRestrictionPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPlaybackRestrictionPoliciesRequest#builder()}
     * </p>
     *
     * @param listPlaybackRestrictionPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest.Builder} to create
     *        a request.
     * @return Result of the ListPlaybackRestrictionPolicies operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackRestrictionPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackRestrictionPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackRestrictionPoliciesResponse listPlaybackRestrictionPolicies(
            Consumer<ListPlaybackRestrictionPoliciesRequest.Builder> listPlaybackRestrictionPoliciesRequest)
            throws AccessDeniedException, ValidationException, PendingVerificationException, ConflictException,
            AwsServiceException, SdkClientException, IvsException {
        return listPlaybackRestrictionPolicies(ListPlaybackRestrictionPoliciesRequest.builder()
                .applyMutation(listPlaybackRestrictionPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackRestrictionPolicies(software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client.listPlaybackRestrictionPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client
     *             .listPlaybackRestrictionPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client.listPlaybackRestrictionPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackRestrictionPolicies(software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlaybackRestrictionPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackRestrictionPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackRestrictionPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackRestrictionPoliciesIterable listPlaybackRestrictionPoliciesPaginator(
            ListPlaybackRestrictionPoliciesRequest listPlaybackRestrictionPoliciesRequest) throws AccessDeniedException,
            ValidationException, PendingVerificationException, ConflictException, AwsServiceException, SdkClientException,
            IvsException {
        return new ListPlaybackRestrictionPoliciesIterable(this, listPlaybackRestrictionPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlaybackRestrictionPolicies(software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client.listPlaybackRestrictionPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client
     *             .listPlaybackRestrictionPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListPlaybackRestrictionPoliciesIterable responses = client.listPlaybackRestrictionPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlaybackRestrictionPolicies(software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlaybackRestrictionPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link ListPlaybackRestrictionPoliciesRequest#builder()}
     * </p>
     *
     * @param listPlaybackRestrictionPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListPlaybackRestrictionPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListPlaybackRestrictionPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlaybackRestrictionPoliciesIterable listPlaybackRestrictionPoliciesPaginator(
            Consumer<ListPlaybackRestrictionPoliciesRequest.Builder> listPlaybackRestrictionPoliciesRequest)
            throws AccessDeniedException, ValidationException, PendingVerificationException, ConflictException,
            AwsServiceException, SdkClientException, IvsException {
        return listPlaybackRestrictionPoliciesPaginator(ListPlaybackRestrictionPoliciesRequest.builder()
                .applyMutation(listPlaybackRestrictionPoliciesRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all recording configurations in your account, in the Amazon Web Services region
     * where the API request is processed.
     * </p>
     *
     * @param listRecordingConfigurationsRequest
     * @return Result of the ListRecordingConfigurations operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListRecordingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordingConfigurationsResponse listRecordingConfigurations(
            ListRecordingConfigurationsRequest listRecordingConfigurationsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all recording configurations in your account, in the Amazon Web Services region
     * where the API request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecordingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecordingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listRecordingConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRecordingConfigurations operation returned by the service.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListRecordingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordingConfigurationsResponse listRecordingConfigurations(
            Consumer<ListRecordingConfigurationsRequest.Builder> listRecordingConfigurationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            IvsException {
        return listRecordingConfigurations(ListRecordingConfigurationsRequest.builder()
                .applyMutation(listRecordingConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecordingConfigurations(software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client.listRecordingConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client
     *             .listRecordingConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client.listRecordingConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecordingConfigurations(software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecordingConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListRecordingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordingConfigurationsIterable listRecordingConfigurationsPaginator(
            ListRecordingConfigurationsRequest listRecordingConfigurationsRequest) throws InternalServerException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return new ListRecordingConfigurationsIterable(this, listRecordingConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecordingConfigurations(software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client.listRecordingConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client
     *             .listRecordingConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListRecordingConfigurationsIterable responses = client.listRecordingConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecordingConfigurations(software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecordingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecordingConfigurationsRequest#builder()}
     * </p>
     *
     * @param listRecordingConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListRecordingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListRecordingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecordingConfigurationsIterable listRecordingConfigurationsPaginator(
            Consumer<ListRecordingConfigurationsRequest.Builder> listRecordingConfigurationsRequest)
            throws InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            IvsException {
        return listRecordingConfigurationsPaginator(ListRecordingConfigurationsRequest.builder()
                .applyMutation(listRecordingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about stream keys for the specified channel.
     * </p>
     *
     * @param listStreamKeysRequest
     * @return Result of the ListStreamKeys operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamKeysResponse listStreamKeys(ListStreamKeysRequest listStreamKeysRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about stream keys for the specified channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamKeysRequest#builder()}
     * </p>
     *
     * @param listStreamKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest.Builder} to create a request.
     * @return Result of the ListStreamKeys operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamKeysResponse listStreamKeys(Consumer<ListStreamKeysRequest.Builder> listStreamKeysRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return listStreamKeys(ListStreamKeysRequest.builder().applyMutation(listStreamKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listStreamKeys(software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamKeys(software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest)} operation.</b>
     * </p>
     *
     * @param listStreamKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamKeysIterable listStreamKeysPaginator(ListStreamKeysRequest listStreamKeysRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return new ListStreamKeysIterable(this, listStreamKeysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listStreamKeys(software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamKeysIterable responses = client.listStreamKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamKeys(software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamKeysRequest#builder()}
     * </p>
     *
     * @param listStreamKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamKeysIterable listStreamKeysPaginator(Consumer<ListStreamKeysRequest.Builder> listStreamKeysRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return listStreamKeysPaginator(ListStreamKeysRequest.builder().applyMutation(listStreamKeysRequest).build());
    }

    /**
     * <p>
     * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where
     * the API request is processed.
     * </p>
     *
     * @param listStreamSessionsRequest
     * @return Result of the ListStreamSessions operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamSessionsResponse listStreamSessions(ListStreamSessionsRequest listStreamSessionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where
     * the API request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest.Builder} to create a request.
     * @return Result of the ListStreamSessions operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamSessionsResponse listStreamSessions(Consumer<ListStreamSessionsRequest.Builder> listStreamSessionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return listStreamSessions(ListStreamSessionsRequest.builder().applyMutation(listStreamSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessions(software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client.listStreamSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client
     *             .listStreamSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client.listStreamSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessions(software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listStreamSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamSessionsIterable listStreamSessionsPaginator(ListStreamSessionsRequest listStreamSessionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return new ListStreamSessionsIterable(this, listStreamSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStreamSessions(software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client.listStreamSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client
     *             .listStreamSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamSessionsIterable responses = client.listStreamSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamSessions(software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamSessionsRequest#builder()}
     * </p>
     *
     * @param listStreamSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamSessionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreamSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreamSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamSessionsIterable listStreamSessionsPaginator(
            Consumer<ListStreamSessionsRequest.Builder> listStreamSessionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listStreamSessionsPaginator(ListStreamSessionsRequest.builder().applyMutation(listStreamSessionsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about live streams in your account, in the Amazon Web Services region where the API
     * request is processed.
     * </p>
     *
     * @param listStreamsRequest
     * @return Result of the ListStreams operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about live streams in your account, in the Amazon Web Services region where the API
     * request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamsRequest#builder()}
     * </p>
     *
     * @param listStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamsRequest.Builder} to create a request.
     * @return Result of the ListStreams operation returned by the service.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest)
            throws AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listStreams(ListStreamsRequest.builder().applyMutation(listStreamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listStreams(software.amazon.awssdk.services.ivs.model.ListStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreams(software.amazon.awssdk.services.ivs.model.ListStreamsRequest)} operation.</b>
     * </p>
     *
     * @param listStreamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsIterable listStreamsPaginator(ListStreamsRequest listStreamsRequest) throws AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, IvsException {
        return new ListStreamsIterable(this, listStreamsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listStreams(software.amazon.awssdk.services.ivs.model.ListStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.ivs.model.ListStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivs.paginators.ListStreamsIterable responses = client.listStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreams(software.amazon.awssdk.services.ivs.model.ListStreamsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamsRequest#builder()}
     * </p>
     *
     * @param listStreamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListStreamsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsIterable listStreamsPaginator(Consumer<ListStreamsRequest.Builder> listStreamsRequest)
            throws AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listStreamsPaginator(ListStreamsRequest.builder().applyMutation(listStreamsRequest).build());
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for the specified ARN.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are
     * allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your
     * data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video
     * Stream</a> in the <i>Amazon IVS User Guide</i>.
     * </p>
     *
     * @param putMetadataRequest
     * @return Result of the PutMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.PutMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default PutMetadataResponse putMetadata(PutMetadataRequest putMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, ChannelNotBroadcastingException, ThrottlingException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are
     * allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your
     * data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html">Embedding Metadata within a Video
     * Stream</a> in the <i>Amazon IVS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMetadataRequest.Builder} avoiding the need to
     * create one manually via {@link PutMetadataRequest#builder()}
     * </p>
     *
     * @param putMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.PutMetadataRequest.Builder} to create a request.
     * @return Result of the PutMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.PutMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default PutMetadataResponse putMetadata(Consumer<PutMetadataRequest.Builder> putMetadataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, ChannelNotBroadcastingException,
            ThrottlingException, AwsServiceException, SdkClientException, IvsException {
        return putMetadata(PutMetadataRequest.builder().applyMutation(putMetadataRequest).build());
    }

    /**
     * <p>
     * Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID.
     * Optionally, you can provide a version to revoke viewer sessions less than and including that version. For
     * instructions on associating a viewer ID with a viewer session, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a>.
     * </p>
     *
     * @param startViewerSessionRevocationRequest
     * @return Result of the StartViewerSessionRevocation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.StartViewerSessionRevocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StartViewerSessionRevocation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartViewerSessionRevocationResponse startViewerSessionRevocation(
            StartViewerSessionRevocationRequest startViewerSessionRevocationRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, ValidationException, PendingVerificationException,
            ThrottlingException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID.
     * Optionally, you can provide a version to revoke viewer sessions less than and including that version. For
     * instructions on associating a viewer ID with a viewer session, see <a
     * href="https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html">Setting Up Private Channels</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartViewerSessionRevocationRequest.Builder}
     * avoiding the need to create one manually via {@link StartViewerSessionRevocationRequest#builder()}
     * </p>
     *
     * @param startViewerSessionRevocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest.Builder} to create a
     *        request.
     * @return Result of the StartViewerSessionRevocation operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.StartViewerSessionRevocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StartViewerSessionRevocation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartViewerSessionRevocationResponse startViewerSessionRevocation(
            Consumer<StartViewerSessionRevocationRequest.Builder> startViewerSessionRevocationRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException,
            PendingVerificationException, ThrottlingException, AwsServiceException, SdkClientException, IvsException {
        return startViewerSessionRevocation(StartViewerSessionRevocationRequest.builder()
                .applyMutation(startViewerSessionRevocationRequest).build());
    }

    /**
     * <p>
     * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with
     * <a>DeleteStreamKey</a> to prevent further streaming to a channel.
     * </p>
     * <note>
     * <p>
     * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream
     * permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.
     * </p>
     * </note>
     *
     * @param stopStreamRequest
     * @return Result of the StopStream operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws StreamUnavailableException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.StopStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream" target="_top">AWS API
     *      Documentation</a>
     */
    default StopStreamResponse stopStream(StopStreamRequest stopStreamRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, ChannelNotBroadcastingException, StreamUnavailableException,
            AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with
     * <a>DeleteStreamKey</a> to prevent further streaming to a channel.
     * </p>
     * <note>
     * <p>
     * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream
     * permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStreamRequest.Builder} avoiding the need to
     * create one manually via {@link StopStreamRequest#builder()}
     * </p>
     *
     * @param stopStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.StopStreamRequest.Builder} to create a request.
     * @return Result of the StopStream operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws ChannelNotBroadcastingException
     * @throws StreamUnavailableException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.StopStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/StopStream" target="_top">AWS API
     *      Documentation</a>
     */
    default StopStreamResponse stopStream(Consumer<StopStreamRequest.Builder> stopStreamRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, ChannelNotBroadcastingException,
            StreamUnavailableException, AwsServiceException, SdkClientException, IvsException {
        return stopStream(StopStreamRequest.builder().applyMutation(stopStreamRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the resource with the specified ARN.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the resource with the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException,
            SdkClientException, IvsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a channel's configuration. Live channels cannot be updated. You must stop the ongoing stream, update the
     * channel, and restart the stream for the changes to take effect.
     * </p>
     *
     * @param updateChannelRequest
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, ConflictException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a channel's configuration. Live channels cannot be updated. You must stop the ongoing stream, update the
     * channel, and restart the stream for the changes to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.UpdateChannelRequest.Builder} to create a request.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ConflictException, AwsServiceException, SdkClientException, IvsException {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * <p>
     * Updates a specified playback restriction policy.
     * </p>
     *
     * @param updatePlaybackRestrictionPolicyRequest
     * @return Result of the UpdatePlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UpdatePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdatePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePlaybackRestrictionPolicyResponse updatePlaybackRestrictionPolicy(
            UpdatePlaybackRestrictionPolicyRequest updatePlaybackRestrictionPolicyRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, PendingVerificationException, ConflictException, AwsServiceException,
            SdkClientException, IvsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified playback restriction policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlaybackRestrictionPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePlaybackRestrictionPolicyRequest#builder()}
     * </p>
     *
     * @param updatePlaybackRestrictionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivs.model.UpdatePlaybackRestrictionPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the UpdatePlaybackRestrictionPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws PendingVerificationException
     * @throws ConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IvsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IvsClient.UpdatePlaybackRestrictionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/UpdatePlaybackRestrictionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePlaybackRestrictionPolicyResponse updatePlaybackRestrictionPolicy(
            Consumer<UpdatePlaybackRestrictionPolicyRequest.Builder> updatePlaybackRestrictionPolicyRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, PendingVerificationException,
            ConflictException, AwsServiceException, SdkClientException, IvsException {
        return updatePlaybackRestrictionPolicy(UpdatePlaybackRestrictionPolicyRequest.builder()
                .applyMutation(updatePlaybackRestrictionPolicyRequest).build());
    }

    /**
     * Create a {@link IvsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IvsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IvsClient}.
     */
    static IvsClientBuilder builder() {
        return new DefaultIvsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default IvsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
