/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlaybackRestrictionPoliciesResponse extends IvsResponse implements
        ToCopyableBuilder<ListPlaybackRestrictionPoliciesResponse.Builder, ListPlaybackRestrictionPoliciesResponse> {
    private static final SdkField<List<PlaybackRestrictionPolicySummary>> PLAYBACK_RESTRICTION_POLICIES_FIELD = SdkField
            .<List<PlaybackRestrictionPolicySummary>> builder(MarshallingType.LIST)
            .memberName("playbackRestrictionPolicies")
            .getter(getter(ListPlaybackRestrictionPoliciesResponse::playbackRestrictionPolicies))
            .setter(setter(Builder::playbackRestrictionPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackRestrictionPolicies")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlaybackRestrictionPolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlaybackRestrictionPolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPlaybackRestrictionPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLAYBACK_RESTRICTION_POLICIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies;

    private final String nextToken;

    private ListPlaybackRestrictionPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.playbackRestrictionPolicies = builder.playbackRestrictionPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlaybackRestrictionPolicies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPlaybackRestrictionPolicies() {
        return playbackRestrictionPolicies != null && !(playbackRestrictionPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlaybackRestrictionPolicies} method.
     * </p>
     * 
     * @return List of the matching policies.
     */
    public final List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies() {
        return playbackRestrictionPolicies;
    }

    /**
     * <p>
     * If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
     * next set.
     * </p>
     * 
     * @return If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *         the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPlaybackRestrictionPolicies() ? playbackRestrictionPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlaybackRestrictionPoliciesResponse)) {
            return false;
        }
        ListPlaybackRestrictionPoliciesResponse other = (ListPlaybackRestrictionPoliciesResponse) obj;
        return hasPlaybackRestrictionPolicies() == other.hasPlaybackRestrictionPolicies()
                && Objects.equals(playbackRestrictionPolicies(), other.playbackRestrictionPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlaybackRestrictionPoliciesResponse")
                .add("PlaybackRestrictionPolicies", hasPlaybackRestrictionPolicies() ? playbackRestrictionPolicies() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "playbackRestrictionPolicies":
            return Optional.ofNullable(clazz.cast(playbackRestrictionPolicies()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlaybackRestrictionPoliciesResponse, T> g) {
        return obj -> g.apply((ListPlaybackRestrictionPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlaybackRestrictionPoliciesResponse> {
        /**
         * <p>
         * List of the matching policies.
         * </p>
         * 
         * @param playbackRestrictionPolicies
         *        List of the matching policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackRestrictionPolicies(Collection<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies);

        /**
         * <p>
         * List of the matching policies.
         * </p>
         * 
         * @param playbackRestrictionPolicies
         *        List of the matching policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackRestrictionPolicies(PlaybackRestrictionPolicySummary... playbackRestrictionPolicies);

        /**
         * <p>
         * List of the matching policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicySummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #playbackRestrictionPolicies(List<PlaybackRestrictionPolicySummary>)}.
         * 
         * @param playbackRestrictionPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playbackRestrictionPolicies(java.util.Collection<PlaybackRestrictionPolicySummary>)
         */
        Builder playbackRestrictionPolicies(Consumer<PlaybackRestrictionPolicySummary.Builder>... playbackRestrictionPolicies);

        /**
         * <p>
         * If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
         * next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to
         *        get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlaybackRestrictionPoliciesResponse model) {
            super(model);
            playbackRestrictionPolicies(model.playbackRestrictionPolicies);
            nextToken(model.nextToken);
        }

        public final List<PlaybackRestrictionPolicySummary.Builder> getPlaybackRestrictionPolicies() {
            List<PlaybackRestrictionPolicySummary.Builder> result = PlaybackRestrictionPolicyListCopier
                    .copyToBuilder(this.playbackRestrictionPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlaybackRestrictionPolicies(
                Collection<PlaybackRestrictionPolicySummary.BuilderImpl> playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies = PlaybackRestrictionPolicyListCopier.copyFromBuilder(playbackRestrictionPolicies);
        }

        @Override
        public final Builder playbackRestrictionPolicies(Collection<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies = PlaybackRestrictionPolicyListCopier.copy(playbackRestrictionPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playbackRestrictionPolicies(PlaybackRestrictionPolicySummary... playbackRestrictionPolicies) {
            playbackRestrictionPolicies(Arrays.asList(playbackRestrictionPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playbackRestrictionPolicies(
                Consumer<PlaybackRestrictionPolicySummary.Builder>... playbackRestrictionPolicies) {
            playbackRestrictionPolicies(Stream.of(playbackRestrictionPolicies)
                    .map(c -> PlaybackRestrictionPolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlaybackRestrictionPoliciesResponse build() {
            return new ListPlaybackRestrictionPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
