/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a PlaybackRestrictionPolicy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlaybackRestrictionPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PlaybackRestrictionPolicySummary.Builder, PlaybackRestrictionPolicySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(PlaybackRestrictionPolicySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> ALLOWED_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedCountries")
            .getter(getter(PlaybackRestrictionPolicySummary::allowedCountries))
            .setter(setter(Builder::allowedCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedOrigins")
            .getter(getter(PlaybackRestrictionPolicySummary::allowedOrigins))
            .setter(setter(Builder::allowedOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_STRICT_ORIGIN_ENFORCEMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableStrictOriginEnforcement")
            .getter(getter(PlaybackRestrictionPolicySummary::enableStrictOriginEnforcement))
            .setter(setter(Builder::enableStrictOriginEnforcement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableStrictOriginEnforcement")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PlaybackRestrictionPolicySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(PlaybackRestrictionPolicySummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ALLOWED_COUNTRIES_FIELD, ALLOWED_ORIGINS_FIELD, ENABLE_STRICT_ORIGIN_ENFORCEMENT_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> allowedCountries;

    private final List<String> allowedOrigins;

    private final Boolean enableStrictOriginEnforcement;

    private final String name;

    private final Map<String, String> tags;

    private PlaybackRestrictionPolicySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.allowedCountries = builder.allowedCountries;
        this.allowedOrigins = builder.allowedOrigins;
        this.enableStrictOriginEnforcement = builder.enableStrictOriginEnforcement;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Playback-restriction-policy ARN
     * </p>
     * 
     * @return Playback-restriction-policy ARN
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedCountries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedCountries() {
        return allowedCountries != null && !(allowedCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries (an
     * empty array).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedCountries} method.
     * </p>
     * 
     * @return A list of country codes that control geoblocking restriction. Allowed values are the officially assigned
     *         <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All
     *         countries (an empty array).
     */
    public final List<String> allowedCountries() {
        return allowedCountries;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedOrigins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedOrigins() {
        return allowedOrigins != null && !(allowedOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the Origin
     * header defined at <a
     * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer.mozilla
     * .org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedOrigins} method.
     * </p>
     * 
     * @return A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the
     *         Origin header defined at <a
     *         href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https:
     *         //developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).
     */
    public final List<String> allowedOrigins() {
        return allowedOrigins;
    }

    /**
     * <p>
     * Whether channel playback is constrained by origin site. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether channel playback is constrained by origin site. Default: <code>false</code>.
     */
    public final Boolean enableStrictOriginEnforcement() {
        return enableStrictOriginEnforcement;
    }

    /**
     * <p>
     * Playback-restriction-policy name. The value does not need to be unique.
     * </p>
     * 
     * @return Playback-restriction-policy name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> for more information, including restrictions that apply to tags and
     * "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is documented
     * there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of 1-50 maps, each of the form
     *         <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> for more information, including restrictions that apply to tags and
     *         "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
     *         documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedCountries() ? allowedCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedOrigins() ? allowedOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableStrictOriginEnforcement());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackRestrictionPolicySummary)) {
            return false;
        }
        PlaybackRestrictionPolicySummary other = (PlaybackRestrictionPolicySummary) obj;
        return Objects.equals(arn(), other.arn()) && hasAllowedCountries() == other.hasAllowedCountries()
                && Objects.equals(allowedCountries(), other.allowedCountries())
                && hasAllowedOrigins() == other.hasAllowedOrigins() && Objects.equals(allowedOrigins(), other.allowedOrigins())
                && Objects.equals(enableStrictOriginEnforcement(), other.enableStrictOriginEnforcement())
                && Objects.equals(name(), other.name()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlaybackRestrictionPolicySummary").add("Arn", arn())
                .add("AllowedCountries", hasAllowedCountries() ? allowedCountries() : null)
                .add("AllowedOrigins", hasAllowedOrigins() ? allowedOrigins() : null)
                .add("EnableStrictOriginEnforcement", enableStrictOriginEnforcement()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "allowedCountries":
            return Optional.ofNullable(clazz.cast(allowedCountries()));
        case "allowedOrigins":
            return Optional.ofNullable(clazz.cast(allowedOrigins()));
        case "enableStrictOriginEnforcement":
            return Optional.ofNullable(clazz.cast(enableStrictOriginEnforcement()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlaybackRestrictionPolicySummary, T> g) {
        return obj -> g.apply((PlaybackRestrictionPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlaybackRestrictionPolicySummary> {
        /**
         * <p>
         * Playback-restriction-policy ARN
         * </p>
         * 
         * @param arn
         *        Playback-restriction-policy ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries
         * (an empty array).
         * </p>
         * 
         * @param allowedCountries
         *        A list of country codes that control geoblocking restriction. Allowed values are the officially
         *        assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes.
         *        Default: All countries (an empty array).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedCountries(Collection<String> allowedCountries);

        /**
         * <p>
         * A list of country codes that control geoblocking restriction. Allowed values are the officially assigned <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes. Default: All countries
         * (an empty array).
         * </p>
         * 
         * @param allowedCountries
         *        A list of country codes that control geoblocking restriction. Allowed values are the officially
         *        assigned <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO 3166-1 alpha-2</a> codes.
         *        Default: All countries (an empty array).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedCountries(String... allowedCountries);

        /**
         * <p>
         * A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the
         * Origin header defined at <a
         * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer
         * .mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).
         * </p>
         * 
         * @param allowedOrigins
         *        A list of origin sites that control CORS restriction. Allowed values are the same as valid values of
         *        the Origin header defined at <a
         *        href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin"
         *        >https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty
         *        array).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(Collection<String> allowedOrigins);

        /**
         * <p>
         * A list of origin sites that control CORS restriction. Allowed values are the same as valid values of the
         * Origin header defined at <a
         * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin">https://developer
         * .mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty array).
         * </p>
         * 
         * @param allowedOrigins
         *        A list of origin sites that control CORS restriction. Allowed values are the same as valid values of
         *        the Origin header defined at <a
         *        href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin"
         *        >https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin</a>. Default: All origins (an empty
         *        array).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedOrigins(String... allowedOrigins);

        /**
         * <p>
         * Whether channel playback is constrained by origin site. Default: <code>false</code>.
         * </p>
         * 
         * @param enableStrictOriginEnforcement
         *        Whether channel playback is constrained by origin site. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableStrictOriginEnforcement(Boolean enableStrictOriginEnforcement);

        /**
         * <p>
         * Playback-restriction-policy name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Playback-restriction-policy name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> for more information, including restrictions that apply to tags and
         * "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         * documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of 1-50 maps, each of the form
         *        <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> for more information, including restrictions that apply to tags and
         *        "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints beyond what is
         *        documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> allowedCountries = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedOrigins = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableStrictOriginEnforcement;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlaybackRestrictionPolicySummary model) {
            arn(model.arn);
            allowedCountries(model.allowedCountries);
            allowedOrigins(model.allowedOrigins);
            enableStrictOriginEnforcement(model.enableStrictOriginEnforcement);
            name(model.name);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAllowedCountries() {
            if (allowedCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedCountries;
        }

        public final void setAllowedCountries(Collection<String> allowedCountries) {
            this.allowedCountries = PlaybackRestrictionPolicyAllowedCountryListCopier.copy(allowedCountries);
        }

        @Override
        public final Builder allowedCountries(Collection<String> allowedCountries) {
            this.allowedCountries = PlaybackRestrictionPolicyAllowedCountryListCopier.copy(allowedCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedCountries(String... allowedCountries) {
            allowedCountries(Arrays.asList(allowedCountries));
            return this;
        }

        public final Collection<String> getAllowedOrigins() {
            if (allowedOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedOrigins;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = PlaybackRestrictionPolicyAllowedOriginListCopier.copy(allowedOrigins);
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = PlaybackRestrictionPolicyAllowedOriginListCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String... allowedOrigins) {
            allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final Boolean getEnableStrictOriginEnforcement() {
            return enableStrictOriginEnforcement;
        }

        public final void setEnableStrictOriginEnforcement(Boolean enableStrictOriginEnforcement) {
            this.enableStrictOriginEnforcement = enableStrictOriginEnforcement;
        }

        @Override
        public final Builder enableStrictOriginEnforcement(Boolean enableStrictOriginEnforcement) {
            this.enableStrictOriginEnforcement = enableStrictOriginEnforcement;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public PlaybackRestrictionPolicySummary build() {
            return new PlaybackRestrictionPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
