/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecordingConfigurationRequest extends IvsRequest implements
        ToCopyableBuilder<CreateRecordingConfigurationRequest.Builder, CreateRecordingConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRecordingConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("destinationConfiguration")
            .getter(getter(CreateRecordingConfigurationRequest::destinationConfiguration))
            .setter(setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRecordingConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ThumbnailConfiguration> THUMBNAIL_CONFIGURATION_FIELD = SdkField
            .<ThumbnailConfiguration> builder(MarshallingType.SDK_POJO).memberName("thumbnailConfiguration")
            .getter(getter(CreateRecordingConfigurationRequest::thumbnailConfiguration))
            .setter(setter(Builder::thumbnailConfiguration)).constructor(ThumbnailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfiguration").build())
            .build();

    private static final SdkField<Integer> RECORDING_RECONNECT_WINDOW_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordingReconnectWindowSeconds")
            .getter(getter(CreateRecordingConfigurationRequest::recordingReconnectWindowSeconds))
            .setter(setter(Builder::recordingReconnectWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingReconnectWindowSeconds")
                    .build()).build();

    private static final SdkField<RenditionConfiguration> RENDITION_CONFIGURATION_FIELD = SdkField
            .<RenditionConfiguration> builder(MarshallingType.SDK_POJO).memberName("renditionConfiguration")
            .getter(getter(CreateRecordingConfigurationRequest::renditionConfiguration))
            .setter(setter(Builder::renditionConfiguration)).constructor(RenditionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DESTINATION_CONFIGURATION_FIELD, TAGS_FIELD, THUMBNAIL_CONFIGURATION_FIELD, RECORDING_RECONNECT_WINDOW_SECONDS_FIELD,
            RENDITION_CONFIGURATION_FIELD));

    private final String name;

    private final DestinationConfiguration destinationConfiguration;

    private final Map<String, String> tags;

    private final ThumbnailConfiguration thumbnailConfiguration;

    private final Integer recordingReconnectWindowSeconds;

    private final RenditionConfiguration renditionConfiguration;

    private CreateRecordingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.tags = builder.tags;
        this.thumbnailConfiguration = builder.thumbnailConfiguration;
        this.recordingReconnectWindowSeconds = builder.recordingReconnectWindowSeconds;
        this.renditionConfiguration = builder.renditionConfiguration;
    }

    /**
     * <p>
     * Recording-configuration name. The value does not need to be unique.
     * </p>
     * 
     * @return Recording-configuration name. The value does not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A complex type that contains a destination configuration for where recorded video will be stored.
     * </p>
     * 
     * @return A complex type that contains a destination configuration for where recorded video will be stored.
     */
    public final DestinationConfiguration destinationConfiguration() {
        return destinationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices and
     * strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details, including restrictions
     * that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific constraints
     * beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details,
     *         including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
     *         service-specific constraints beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify the
     * interval at which thumbnails are generated for the live session.
     * </p>
     * 
     * @return A complex type that allows you to enable/disable the recording of thumbnails for a live session and
     *         modify the interval at which thumbnails are generated for the live session.
     */
    public final ThumbnailConfiguration thumbnailConfiguration() {
        return thumbnailConfiguration;
    }

    /**
     * <p>
     * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be
     * considered a single broadcast and merged together. Default: 0.
     * </p>
     * 
     * @return If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will
     *         be considered a single broadcast and merged together. Default: 0.
     */
    public final Integer recordingReconnectWindowSeconds() {
        return recordingReconnectWindowSeconds;
    }

    /**
     * <p>
     * Object that describes which renditions should be recorded for a stream.
     * </p>
     * 
     * @return Object that describes which renditions should be recorded for a stream.
     */
    public final RenditionConfiguration renditionConfiguration() {
        return renditionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(recordingReconnectWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(renditionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecordingConfigurationRequest)) {
            return false;
        }
        CreateRecordingConfigurationRequest other = (CreateRecordingConfigurationRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(destinationConfiguration(), other.destinationConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(thumbnailConfiguration(), other.thumbnailConfiguration())
                && Objects.equals(recordingReconnectWindowSeconds(), other.recordingReconnectWindowSeconds())
                && Objects.equals(renditionConfiguration(), other.renditionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecordingConfigurationRequest").add("Name", name())
                .add("DestinationConfiguration", destinationConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ThumbnailConfiguration", thumbnailConfiguration())
                .add("RecordingReconnectWindowSeconds", recordingReconnectWindowSeconds())
                .add("RenditionConfiguration", renditionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "destinationConfiguration":
            return Optional.ofNullable(clazz.cast(destinationConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "thumbnailConfiguration":
            return Optional.ofNullable(clazz.cast(thumbnailConfiguration()));
        case "recordingReconnectWindowSeconds":
            return Optional.ofNullable(clazz.cast(recordingReconnectWindowSeconds()));
        case "renditionConfiguration":
            return Optional.ofNullable(clazz.cast(renditionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecordingConfigurationRequest, T> g) {
        return obj -> g.apply((CreateRecordingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRecordingConfigurationRequest> {
        /**
         * <p>
         * Recording-configuration name. The value does not need to be unique.
         * </p>
         * 
         * @param name
         *        Recording-configuration name. The value does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A complex type that contains a destination configuration for where recorded video will be stored.
         * </p>
         * 
         * @param destinationConfiguration
         *        A complex type that contains a destination configuration for where recorded video will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfiguration(DestinationConfiguration destinationConfiguration);

        /**
         * <p>
         * A complex type that contains a destination configuration for where recorded video will be stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationConfiguration(DestinationConfiguration)}.
         * 
         * @param destinationConfiguration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfiguration(DestinationConfiguration)
         */
        default Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return destinationConfiguration(DestinationConfiguration.builder().applyMutation(destinationConfiguration).build());
        }

        /**
         * <p>
         * Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
         * and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details, including
         * restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific
         * constraints beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for
         *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
         *        IVS has no service-specific constraints beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify
         * the interval at which thumbnails are generated for the live session.
         * </p>
         * 
         * @param thumbnailConfiguration
         *        A complex type that allows you to enable/disable the recording of thumbnails for a live session and
         *        modify the interval at which thumbnails are generated for the live session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfiguration(ThumbnailConfiguration thumbnailConfiguration);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a live session and modify
         * the interval at which thumbnails are generated for the live session.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThumbnailConfiguration.Builder} avoiding
         * the need to create one manually via {@link ThumbnailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThumbnailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #thumbnailConfiguration(ThumbnailConfiguration)}.
         * 
         * @param thumbnailConfiguration
         *        a consumer that will call methods on {@link ThumbnailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfiguration(ThumbnailConfiguration)
         */
        default Builder thumbnailConfiguration(Consumer<ThumbnailConfiguration.Builder> thumbnailConfiguration) {
            return thumbnailConfiguration(ThumbnailConfiguration.builder().applyMutation(thumbnailConfiguration).build());
        }

        /**
         * <p>
         * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be
         * considered a single broadcast and merged together. Default: 0.
         * </p>
         * 
         * @param recordingReconnectWindowSeconds
         *        If a broadcast disconnects and then reconnects within the specified interval, the multiple streams
         *        will be considered a single broadcast and merged together. Default: 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds);

        /**
         * <p>
         * Object that describes which renditions should be recorded for a stream.
         * </p>
         * 
         * @param renditionConfiguration
         *        Object that describes which renditions should be recorded for a stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditionConfiguration(RenditionConfiguration renditionConfiguration);

        /**
         * <p>
         * Object that describes which renditions should be recorded for a stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenditionConfiguration.Builder} avoiding
         * the need to create one manually via {@link RenditionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenditionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #renditionConfiguration(RenditionConfiguration)}.
         * 
         * @param renditionConfiguration
         *        a consumer that will call methods on {@link RenditionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renditionConfiguration(RenditionConfiguration)
         */
        default Builder renditionConfiguration(Consumer<RenditionConfiguration.Builder> renditionConfiguration) {
            return renditionConfiguration(RenditionConfiguration.builder().applyMutation(renditionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRequest.BuilderImpl implements Builder {
        private String name;

        private DestinationConfiguration destinationConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ThumbnailConfiguration thumbnailConfiguration;

        private Integer recordingReconnectWindowSeconds;

        private RenditionConfiguration renditionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecordingConfigurationRequest model) {
            super(model);
            name(model.name);
            destinationConfiguration(model.destinationConfiguration);
            tags(model.tags);
            thumbnailConfiguration(model.thumbnailConfiguration);
            recordingReconnectWindowSeconds(model.recordingReconnectWindowSeconds);
            renditionConfiguration(model.renditionConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return destinationConfiguration != null ? destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final ThumbnailConfiguration.Builder getThumbnailConfiguration() {
            return thumbnailConfiguration != null ? thumbnailConfiguration.toBuilder() : null;
        }

        public final void setThumbnailConfiguration(ThumbnailConfiguration.BuilderImpl thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration != null ? thumbnailConfiguration.build() : null;
        }

        @Override
        public final Builder thumbnailConfiguration(ThumbnailConfiguration thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        public final Integer getRecordingReconnectWindowSeconds() {
            return recordingReconnectWindowSeconds;
        }

        public final void setRecordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
        }

        @Override
        public final Builder recordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
            return this;
        }

        public final RenditionConfiguration.Builder getRenditionConfiguration() {
            return renditionConfiguration != null ? renditionConfiguration.toBuilder() : null;
        }

        public final void setRenditionConfiguration(RenditionConfiguration.BuilderImpl renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration != null ? renditionConfiguration.build() : null;
        }

        @Override
        public final Builder renditionConfiguration(RenditionConfiguration renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecordingConfigurationRequest build() {
            return new CreateRecordingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
