/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies information needed to stream using the SRT protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Srt implements SdkPojo, Serializable, ToCopyableBuilder<Srt.Builder, Srt> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(Srt::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> PASSPHRASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("passphrase").getter(getter(Srt::passphrase)).setter(setter(Builder::passphrase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passphrase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            PASSPHRASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final String passphrase;

    private Srt(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.passphrase = builder.passphrase;
    }

    /**
     * <p>
     * The endpoint to be used when streaming with IVS using the SRT protocol.
     * </p>
     * 
     * @return The endpoint to be used when streaming with IVS using the SRT protocol.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Auto-generated passphrase to enable encryption. This field is applicable only if the end user has <i>not</i>
     * enabled the <code>insecureIngest</code> option for the channel.
     * </p>
     * 
     * @return Auto-generated passphrase to enable encryption. This field is applicable only if the end user has
     *         <i>not</i> enabled the <code>insecureIngest</code> option for the channel.
     */
    public final String passphrase() {
        return passphrase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(passphrase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Srt)) {
            return false;
        }
        Srt other = (Srt) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(passphrase(), other.passphrase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Srt").add("Endpoint", endpoint())
                .add("Passphrase", passphrase() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "passphrase":
            return Optional.ofNullable(clazz.cast(passphrase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Srt, T> g) {
        return obj -> g.apply((Srt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Srt> {
        /**
         * <p>
         * The endpoint to be used when streaming with IVS using the SRT protocol.
         * </p>
         * 
         * @param endpoint
         *        The endpoint to be used when streaming with IVS using the SRT protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Auto-generated passphrase to enable encryption. This field is applicable only if the end user has <i>not</i>
         * enabled the <code>insecureIngest</code> option for the channel.
         * </p>
         * 
         * @param passphrase
         *        Auto-generated passphrase to enable encryption. This field is applicable only if the end user has
         *        <i>not</i> enabled the <code>insecureIngest</code> option for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passphrase(String passphrase);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private String passphrase;

        private BuilderImpl() {
        }

        private BuilderImpl(Srt model) {
            endpoint(model.endpoint);
            passphrase(model.passphrase);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getPassphrase() {
            return passphrase;
        }

        public final void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public final Builder passphrase(String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        @Override
        public Srt build() {
            return new Srt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
