/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStartViewerSessionRevocationResponse extends IvsResponse implements
        ToCopyableBuilder<BatchStartViewerSessionRevocationResponse.Builder, BatchStartViewerSessionRevocationResponse> {
    private static final SdkField<List<BatchStartViewerSessionRevocationError>> ERRORS_FIELD = SdkField
            .<List<BatchStartViewerSessionRevocationError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchStartViewerSessionRevocationResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchStartViewerSessionRevocationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchStartViewerSessionRevocationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchStartViewerSessionRevocationError> errors;

    private BatchStartViewerSessionRevocationResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the
     *         request.
     */
    public final List<BatchStartViewerSessionRevocationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartViewerSessionRevocationResponse)) {
            return false;
        }
        BatchStartViewerSessionRevocationResponse other = (BatchStartViewerSessionRevocationResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStartViewerSessionRevocationResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStartViewerSessionRevocationResponse, T> g) {
        return obj -> g.apply((BatchStartViewerSessionRevocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchStartViewerSessionRevocationResponse> {
        /**
         * <p>
         * Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the
         * request.
         * </p>
         * 
         * @param errors
         *        Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchStartViewerSessionRevocationError> errors);

        /**
         * <p>
         * Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the
         * request.
         * </p>
         * 
         * @param errors
         *        Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchStartViewerSessionRevocationError... errors);

        /**
         * <p>
         * Each error object is related to a specific <code>channelArn</code> and <code>viewerId</code> pair in the
         * request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchStartViewerSessionRevocationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchStartViewerSessionRevocationError>)
         */
        Builder errors(Consumer<BatchStartViewerSessionRevocationError.Builder>... errors);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private List<BatchStartViewerSessionRevocationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartViewerSessionRevocationResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<BatchStartViewerSessionRevocationError.Builder> getErrors() {
            List<BatchStartViewerSessionRevocationError.Builder> result = BatchStartViewerSessionRevocationErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchStartViewerSessionRevocationError.BuilderImpl> errors) {
            this.errors = BatchStartViewerSessionRevocationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchStartViewerSessionRevocationError> errors) {
            this.errors = BatchStartViewerSessionRevocationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchStartViewerSessionRevocationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchStartViewerSessionRevocationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchStartViewerSessionRevocationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchStartViewerSessionRevocationResponse build() {
            return new BatchStartViewerSessionRevocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
