/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Channel::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> AUTHORIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("authorized").getter(getter(Channel::authorized)).setter(setter(Builder::authorized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorized").build()).build();

    private static final SdkField<String> CONTAINER_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerFormat").getter(getter(Channel::containerFormatAsString))
            .setter(setter(Builder::containerFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerFormat").build()).build();

    private static final SdkField<String> INGEST_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestEndpoint").getter(getter(Channel::ingestEndpoint)).setter(setter(Builder::ingestEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoint").build()).build();

    private static final SdkField<Boolean> INSECURE_INGEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("insecureIngest").getter(getter(Channel::insecureIngest)).setter(setter(Builder::insecureIngest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureIngest").build()).build();

    private static final SdkField<String> LATENCY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latencyMode").getter(getter(Channel::latencyModeAsString)).setter(setter(Builder::latencyMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMode").build()).build();

    private static final SdkField<MultitrackInputConfiguration> MULTITRACK_INPUT_CONFIGURATION_FIELD = SdkField
            .<MultitrackInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("multitrackInputConfiguration")
            .getter(getter(Channel::multitrackInputConfiguration))
            .setter(setter(Builder::multitrackInputConfiguration))
            .constructor(MultitrackInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multitrackInputConfiguration")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Channel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLAYBACK_RESTRICTION_POLICY_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("playbackRestrictionPolicyArn")
            .getter(getter(Channel::playbackRestrictionPolicyArn))
            .setter(setter(Builder::playbackRestrictionPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackRestrictionPolicyArn")
                    .build()).build();

    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("playbackUrl").getter(getter(Channel::playbackUrl)).setter(setter(Builder::playbackUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()).build();

    private static final SdkField<String> PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("preset")
            .getter(getter(Channel::presetAsString)).setter(setter(Builder::preset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()).build();

    private static final SdkField<String> RECORDING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingConfigurationArn").getter(getter(Channel::recordingConfigurationArn))
            .setter(setter(Builder::recordingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurationArn").build())
            .build();

    private static final SdkField<Srt> SRT_FIELD = SdkField.<Srt> builder(MarshallingType.SDK_POJO).memberName("srt")
            .getter(getter(Channel::srt)).setter(setter(Builder::srt)).constructor(Srt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Channel::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Channel::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHORIZED_FIELD,
            CONTAINER_FORMAT_FIELD, INGEST_ENDPOINT_FIELD, INSECURE_INGEST_FIELD, LATENCY_MODE_FIELD,
            MULTITRACK_INPUT_CONFIGURATION_FIELD, NAME_FIELD, PLAYBACK_RESTRICTION_POLICY_ARN_FIELD, PLAYBACK_URL_FIELD,
            PRESET_FIELD, RECORDING_CONFIGURATION_ARN_FIELD, SRT_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Boolean authorized;

    private final String containerFormat;

    private final String ingestEndpoint;

    private final Boolean insecureIngest;

    private final String latencyMode;

    private final MultitrackInputConfiguration multitrackInputConfiguration;

    private final String name;

    private final String playbackRestrictionPolicyArn;

    private final String playbackUrl;

    private final String preset;

    private final String recordingConfigurationArn;

    private final Srt srt;

    private final Map<String, String> tags;

    private final String type;

    private Channel(BuilderImpl builder) {
        this.arn = builder.arn;
        this.authorized = builder.authorized;
        this.containerFormat = builder.containerFormat;
        this.ingestEndpoint = builder.ingestEndpoint;
        this.insecureIngest = builder.insecureIngest;
        this.latencyMode = builder.latencyMode;
        this.multitrackInputConfiguration = builder.multitrackInputConfiguration;
        this.name = builder.name;
        this.playbackRestrictionPolicyArn = builder.playbackRestrictionPolicyArn;
        this.playbackUrl = builder.playbackUrl;
        this.preset = builder.preset;
        this.recordingConfigurationArn = builder.recordingConfigurationArn;
        this.srt = builder.srt;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * Channel ARN.
     * </p>
     * 
     * @return Channel ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
     */
    public final Boolean authorized() {
        return authorized;
    }

    /**
     * <p>
     * Indicates which content-packaging format is used (MPEG-TS or fMP4). If <code>multitrackInputConfiguration</code>
     * is specified and <code>enabled</code> is <code>true</code>, then <code>containerFormat</code> is required and
     * must be set to <code>FRAGMENTED_MP4</code>. Otherwise, <code>containerFormat</code> may be set to <code>TS</code>
     * or <code>FRAGMENTED_MP4</code>. Default: <code>TS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return Indicates which content-packaging format is used (MPEG-TS or fMP4). If
     *         <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>,
     *         then <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>. Otherwise,
     *         <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>. Default:
     *         <code>TS</code>.
     * @see ContainerFormat
     */
    public final ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(containerFormat);
    }

    /**
     * <p>
     * Indicates which content-packaging format is used (MPEG-TS or fMP4). If <code>multitrackInputConfiguration</code>
     * is specified and <code>enabled</code> is <code>true</code>, then <code>containerFormat</code> is required and
     * must be set to <code>FRAGMENTED_MP4</code>. Otherwise, <code>containerFormat</code> may be set to <code>TS</code>
     * or <code>FRAGMENTED_MP4</code>. Default: <code>TS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return Indicates which content-packaging format is used (MPEG-TS or fMP4). If
     *         <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>,
     *         then <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>. Otherwise,
     *         <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>. Default:
     *         <code>TS</code>.
     * @see ContainerFormat
     */
    public final String containerFormatAsString() {
        return containerFormat;
    }

    /**
     * <p>
     * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
     * </p>
     * 
     * @return Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming
     *         software.
     */
    public final String ingestEndpoint() {
        return ingestEndpoint;
    }

    /**
     * <p>
     * Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
     * </p>
     * 
     * @return Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
     */
    public final Boolean insecureIngest() {
        return insecureIngest;
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final ChannelLatencyMode latencyMode() {
        return ChannelLatencyMode.fromValue(latencyMode);
    }

    /**
     * <p>
     * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latencyMode} will
     * return {@link ChannelLatencyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #latencyModeAsString}.
     * </p>
     * 
     * @return Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
     *         <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
     * @see ChannelLatencyMode
     */
    public final String latencyModeAsString() {
        return latencyMode;
    }

    /**
     * <p>
     * Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
     * </p>
     * 
     * @return Object specifying multitrack input configuration. Default: no multitrack input configuration is
     *         specified.
     */
    public final MultitrackInputConfiguration multitrackInputConfiguration() {
        return multitrackInputConfiguration;
    }

    /**
     * <p>
     * Channel name.
     * </p>
     * 
     * @return Channel name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback restriction.
     * Default: "" (empty string, no playback restriction policy is applied).
     * </p>
     * 
     * @return Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
     *         restriction. Default: "" (empty string, no playback restriction policy is applied).
     */
    public final String playbackRestrictionPolicyArn() {
        return playbackRestrictionPolicyArn;
    }

    /**
     * <p>
     * Channel playback URL.
     * </p>
     * 
     * @return Channel playback URL.
     */
    public final String playbackUrl() {
        return playbackUrl;
    }

    /**
     * <p>
     * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>),
     * <code>preset</code> is the empty string (<code>""</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preset} will
     * return {@link TranscodePreset#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #presetAsString}.
     * </p>
     * 
     * @return Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     *         <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     *         <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
     *         <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
     * @see TranscodePreset
     */
    public final TranscodePreset preset() {
        return TranscodePreset.fromValue(preset);
    }

    /**
     * <p>
     * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>),
     * <code>preset</code> is the empty string (<code>""</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preset} will
     * return {@link TranscodePreset#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #presetAsString}.
     * </p>
     * 
     * @return Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
     *         <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
     *         <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
     *         <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
     * @see TranscodePreset
     */
    public final String presetAsString() {
        return preset;
    }

    /**
     * <p>
     * Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. Default: ""
     * (empty string, recording is disabled).
     * </p>
     * 
     * @return Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording.
     *         Default: "" (empty string, recording is disabled).
     */
    public final String recordingConfigurationArn() {
        return recordingConfigurationArn;
    }

    /**
     * <p>
     * Specifies the endpoint and optional passphrase for streaming with the SRT protocol.
     * </p>
     * 
     * @return Specifies the endpoint and optional passphrase for streaming with the SRT protocol.
     */
    public final Srt srt() {
        return srt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>. See
     * <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
     * and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details, including
     * restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no service-specific
     * constraints beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of 1-50 maps, each of the form
     *         <code>string:string (key:value)</code>. See <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
     *         practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details,
     *         including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
     *         service-specific constraints beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For
     * details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     * Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. For details, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     *         Types</a>.
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>. For
     * details, see <a href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     * Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
     *         resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
     *         <code>STANDARD</code>. For details, see <a
     *         href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
     *         Types</a>.
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authorized());
        hashCode = 31 * hashCode + Objects.hashCode(containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ingestEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(insecureIngest());
        hashCode = 31 * hashCode + Objects.hashCode(latencyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multitrackInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackRestrictionPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(presetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(srt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(authorized(), other.authorized())
                && Objects.equals(containerFormatAsString(), other.containerFormatAsString())
                && Objects.equals(ingestEndpoint(), other.ingestEndpoint())
                && Objects.equals(insecureIngest(), other.insecureIngest())
                && Objects.equals(latencyModeAsString(), other.latencyModeAsString())
                && Objects.equals(multitrackInputConfiguration(), other.multitrackInputConfiguration())
                && Objects.equals(name(), other.name())
                && Objects.equals(playbackRestrictionPolicyArn(), other.playbackRestrictionPolicyArn())
                && Objects.equals(playbackUrl(), other.playbackUrl()) && Objects.equals(presetAsString(), other.presetAsString())
                && Objects.equals(recordingConfigurationArn(), other.recordingConfigurationArn())
                && Objects.equals(srt(), other.srt()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Channel").add("Arn", arn()).add("Authorized", authorized())
                .add("ContainerFormat", containerFormatAsString()).add("IngestEndpoint", ingestEndpoint())
                .add("InsecureIngest", insecureIngest()).add("LatencyMode", latencyModeAsString())
                .add("MultitrackInputConfiguration", multitrackInputConfiguration()).add("Name", name())
                .add("PlaybackRestrictionPolicyArn", playbackRestrictionPolicyArn()).add("PlaybackUrl", playbackUrl())
                .add("Preset", presetAsString()).add("RecordingConfigurationArn", recordingConfigurationArn()).add("Srt", srt())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "authorized":
            return Optional.ofNullable(clazz.cast(authorized()));
        case "containerFormat":
            return Optional.ofNullable(clazz.cast(containerFormatAsString()));
        case "ingestEndpoint":
            return Optional.ofNullable(clazz.cast(ingestEndpoint()));
        case "insecureIngest":
            return Optional.ofNullable(clazz.cast(insecureIngest()));
        case "latencyMode":
            return Optional.ofNullable(clazz.cast(latencyModeAsString()));
        case "multitrackInputConfiguration":
            return Optional.ofNullable(clazz.cast(multitrackInputConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "playbackRestrictionPolicyArn":
            return Optional.ofNullable(clazz.cast(playbackRestrictionPolicyArn()));
        case "playbackUrl":
            return Optional.ofNullable(clazz.cast(playbackUrl()));
        case "preset":
            return Optional.ofNullable(clazz.cast(presetAsString()));
        case "recordingConfigurationArn":
            return Optional.ofNullable(clazz.cast(recordingConfigurationArn()));
        case "srt":
            return Optional.ofNullable(clazz.cast(srt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("authorized", AUTHORIZED_FIELD);
        map.put("containerFormat", CONTAINER_FORMAT_FIELD);
        map.put("ingestEndpoint", INGEST_ENDPOINT_FIELD);
        map.put("insecureIngest", INSECURE_INGEST_FIELD);
        map.put("latencyMode", LATENCY_MODE_FIELD);
        map.put("multitrackInputConfiguration", MULTITRACK_INPUT_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("playbackRestrictionPolicyArn", PLAYBACK_RESTRICTION_POLICY_ARN_FIELD);
        map.put("playbackUrl", PLAYBACK_URL_FIELD);
        map.put("preset", PRESET_FIELD);
        map.put("recordingConfigurationArn", RECORDING_CONFIGURATION_ARN_FIELD);
        map.put("srt", SRT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * Channel ARN.
         * </p>
         * 
         * @param arn
         *        Channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * </p>
         * 
         * @param authorized
         *        Whether the channel is private (enabled for playback authorization). Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorized(Boolean authorized);

        /**
         * <p>
         * Indicates which content-packaging format is used (MPEG-TS or fMP4). If
         * <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>, then
         * <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>. Otherwise,
         * <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>. Default:
         * <code>TS</code>.
         * </p>
         * 
         * @param containerFormat
         *        Indicates which content-packaging format is used (MPEG-TS or fMP4). If
         *        <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>,
         *        then <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>.
         *        Otherwise, <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>.
         *        Default: <code>TS</code>.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(String containerFormat);

        /**
         * <p>
         * Indicates which content-packaging format is used (MPEG-TS or fMP4). If
         * <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>, then
         * <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>. Otherwise,
         * <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>. Default:
         * <code>TS</code>.
         * </p>
         * 
         * @param containerFormat
         *        Indicates which content-packaging format is used (MPEG-TS or fMP4). If
         *        <code>multitrackInputConfiguration</code> is specified and <code>enabled</code> is <code>true</code>,
         *        then <code>containerFormat</code> is required and must be set to <code>FRAGMENTED_MP4</code>.
         *        Otherwise, <code>containerFormat</code> may be set to <code>TS</code> or <code>FRAGMENTED_MP4</code>.
         *        Default: <code>TS</code>.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(ContainerFormat containerFormat);

        /**
         * <p>
         * Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
         * </p>
         * 
         * @param ingestEndpoint
         *        Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming
         *        software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoint(String ingestEndpoint);

        /**
         * <p>
         * Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
         * </p>
         * 
         * @param insecureIngest
         *        Whether the channel allows insecure RTMP ingest. Default: <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureIngest(Boolean insecureIngest);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(String latencyMode);

        /**
         * <p>
         * Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         * <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
         * </p>
         * 
         * @param latencyMode
         *        Channel latency mode. Use <code>NORMAL</code> to broadcast and deliver live video up to Full HD. Use
         *        <code>LOW</code> for near-real-time interaction with viewers. Default: <code>LOW</code>.
         * @see ChannelLatencyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelLatencyMode
         */
        Builder latencyMode(ChannelLatencyMode latencyMode);

        /**
         * <p>
         * Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
         * </p>
         * 
         * @param multitrackInputConfiguration
         *        Object specifying multitrack input configuration. Default: no multitrack input configuration is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multitrackInputConfiguration(MultitrackInputConfiguration multitrackInputConfiguration);

        /**
         * <p>
         * Object specifying multitrack input configuration. Default: no multitrack input configuration is specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultitrackInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link MultitrackInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultitrackInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #multitrackInputConfiguration(MultitrackInputConfiguration)}.
         * 
         * @param multitrackInputConfiguration
         *        a consumer that will call methods on {@link MultitrackInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multitrackInputConfiguration(MultitrackInputConfiguration)
         */
        default Builder multitrackInputConfiguration(Consumer<MultitrackInputConfiguration.Builder> multitrackInputConfiguration) {
            return multitrackInputConfiguration(MultitrackInputConfiguration.builder()
                    .applyMutation(multitrackInputConfiguration).build());
        }

        /**
         * <p>
         * Channel name.
         * </p>
         * 
         * @param name
         *        Channel name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
         * restriction. Default: "" (empty string, no playback restriction policy is applied).
         * </p>
         * 
         * @param playbackRestrictionPolicyArn
         *        Playback-restriction-policy ARN. A valid ARN value here both specifies the ARN and enables playback
         *        restriction. Default: "" (empty string, no playback restriction policy is applied).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackRestrictionPolicyArn(String playbackRestrictionPolicyArn);

        /**
         * <p>
         * Channel playback URL.
         * </p>
         * 
         * @param playbackUrl
         *        Channel playback URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackUrl(String playbackUrl);

        /**
         * <p>
         * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>
         * ), <code>preset</code> is the empty string (<code>""</code>).
         * </p>
         * 
         * @param preset
         *        Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         *        <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         *        <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
         *        <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
         * @see TranscodePreset
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscodePreset
         */
        Builder preset(String preset);

        /**
         * <p>
         * Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         * <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         * <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and <code>STANDARD</code>
         * ), <code>preset</code> is the empty string (<code>""</code>).
         * </p>
         * 
         * @param preset
         *        Optional transcode preset for the channel. This is selectable only for <code>ADVANCED_HD</code> and
         *        <code>ADVANCED_SD</code> channel types. For those channel types, the default <code>preset</code> is
         *        <code>HIGHER_BANDWIDTH_DELIVERY</code>. For other channel types (<code>BASIC</code> and
         *        <code>STANDARD</code>), <code>preset</code> is the empty string (<code>""</code>).
         * @see TranscodePreset
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscodePreset
         */
        Builder preset(TranscodePreset preset);

        /**
         * <p>
         * Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording. Default: ""
         * (empty string, recording is disabled).
         * </p>
         * 
         * @param recordingConfigurationArn
         *        Recording-configuration ARN. A valid ARN value here both specifies the ARN and enables recording.
         *        Default: "" (empty string, recording is disabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurationArn(String recordingConfigurationArn);

        /**
         * <p>
         * Specifies the endpoint and optional passphrase for streaming with the SRT protocol.
         * </p>
         * 
         * @param srt
         *        Specifies the endpoint and optional passphrase for streaming with the SRT protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srt(Srt srt);

        /**
         * <p>
         * Specifies the endpoint and optional passphrase for streaming with the SRT protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link Srt.Builder} avoiding the need to create
         * one manually via {@link Srt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Srt.Builder#build()} is called immediately and its result is
         * passed to {@link #srt(Srt)}.
         * 
         * @param srt
         *        a consumer that will call methods on {@link Srt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srt(Srt)
         */
        default Builder srt(Consumer<Srt.Builder> srt) {
            return srt(Srt.builder().applyMutation(srt).build());
        }

        /**
         * <p>
         * Tags attached to the resource. Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.
         * See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         * practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for details,
         * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         * service-specific constraints beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of 1-50 maps, each of the form
         *        <code>string:string (key:value)</code>. See <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best
         *        practices and strategies</a> in <i>Tagging Amazon Web Services Resources and Tag Editor</i> for
         *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
         *        IVS has no service-specific constraints beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * For details, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        input resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. For details, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
         *        Types</a>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable input
         * resolution or bitrate, the stream probably will disconnect immediately.</i> Default: <code>STANDARD</code>.
         * For details, see <a
         * href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel Types</a>.
         * </p>
         * 
         * @param type
         *        Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable
         *        input resolution or bitrate, the stream probably will disconnect immediately.</i> Default:
         *        <code>STANDARD</code>. For details, see <a
         *        href="https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html">Channel
         *        Types</a>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Boolean authorized;

        private String containerFormat;

        private String ingestEndpoint;

        private Boolean insecureIngest;

        private String latencyMode;

        private MultitrackInputConfiguration multitrackInputConfiguration;

        private String name;

        private String playbackRestrictionPolicyArn;

        private String playbackUrl;

        private String preset;

        private String recordingConfigurationArn;

        private Srt srt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            arn(model.arn);
            authorized(model.authorized);
            containerFormat(model.containerFormat);
            ingestEndpoint(model.ingestEndpoint);
            insecureIngest(model.insecureIngest);
            latencyMode(model.latencyMode);
            multitrackInputConfiguration(model.multitrackInputConfiguration);
            name(model.name);
            playbackRestrictionPolicyArn(model.playbackRestrictionPolicyArn);
            playbackUrl(model.playbackUrl);
            preset(model.preset);
            recordingConfigurationArn(model.recordingConfigurationArn);
            srt(model.srt);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getAuthorized() {
            return authorized;
        }

        public final void setAuthorized(Boolean authorized) {
            this.authorized = authorized;
        }

        @Override
        public final Builder authorized(Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        public final String getContainerFormat() {
            return containerFormat;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat == null ? null : containerFormat.toString());
            return this;
        }

        public final String getIngestEndpoint() {
            return ingestEndpoint;
        }

        public final void setIngestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
        }

        @Override
        public final Builder ingestEndpoint(String ingestEndpoint) {
            this.ingestEndpoint = ingestEndpoint;
            return this;
        }

        public final Boolean getInsecureIngest() {
            return insecureIngest;
        }

        public final void setInsecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
        }

        @Override
        public final Builder insecureIngest(Boolean insecureIngest) {
            this.insecureIngest = insecureIngest;
            return this;
        }

        public final String getLatencyMode() {
            return latencyMode;
        }

        public final void setLatencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
        }

        @Override
        public final Builder latencyMode(String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        @Override
        public final Builder latencyMode(ChannelLatencyMode latencyMode) {
            this.latencyMode(latencyMode == null ? null : latencyMode.toString());
            return this;
        }

        public final MultitrackInputConfiguration.Builder getMultitrackInputConfiguration() {
            return multitrackInputConfiguration != null ? multitrackInputConfiguration.toBuilder() : null;
        }

        public final void setMultitrackInputConfiguration(MultitrackInputConfiguration.BuilderImpl multitrackInputConfiguration) {
            this.multitrackInputConfiguration = multitrackInputConfiguration != null ? multitrackInputConfiguration.build()
                    : null;
        }

        @Override
        public final Builder multitrackInputConfiguration(MultitrackInputConfiguration multitrackInputConfiguration) {
            this.multitrackInputConfiguration = multitrackInputConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackRestrictionPolicyArn() {
            return playbackRestrictionPolicyArn;
        }

        public final void setPlaybackRestrictionPolicyArn(String playbackRestrictionPolicyArn) {
            this.playbackRestrictionPolicyArn = playbackRestrictionPolicyArn;
        }

        @Override
        public final Builder playbackRestrictionPolicyArn(String playbackRestrictionPolicyArn) {
            this.playbackRestrictionPolicyArn = playbackRestrictionPolicyArn;
            return this;
        }

        public final String getPlaybackUrl() {
            return playbackUrl;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final String getPreset() {
            return preset;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        @Override
        public final Builder preset(TranscodePreset preset) {
            this.preset(preset == null ? null : preset.toString());
            return this;
        }

        public final String getRecordingConfigurationArn() {
            return recordingConfigurationArn;
        }

        public final void setRecordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
        }

        @Override
        public final Builder recordingConfigurationArn(String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        public final Srt.Builder getSrt() {
            return srt != null ? srt.toBuilder() : null;
        }

        public final void setSrt(Srt.BuilderImpl srt) {
            this.srt = srt != null ? srt.build() : null;
        }

        @Override
        public final Builder srt(Srt srt) {
            this.srt = srt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
