/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamKeyResponse extends IvsResponse implements
        ToCopyableBuilder<CreateStreamKeyResponse.Builder, CreateStreamKeyResponse> {
    private static final SdkField<StreamKey> STREAM_KEY_FIELD = SdkField.<StreamKey> builder(MarshallingType.SDK_POJO)
            .memberName("streamKey").getter(getter(CreateStreamKeyResponse::streamKey)).setter(setter(Builder::streamKey))
            .constructor(StreamKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StreamKey streamKey;

    private CreateStreamKeyResponse(BuilderImpl builder) {
        super(builder);
        this.streamKey = builder.streamKey;
    }

    /**
     * <p>
     * Stream key used to authenticate an RTMPS stream for ingestion.
     * </p>
     * 
     * @return Stream key used to authenticate an RTMPS stream for ingestion.
     */
    public final StreamKey streamKey() {
        return streamKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamKeyResponse)) {
            return false;
        }
        CreateStreamKeyResponse other = (CreateStreamKeyResponse) obj;
        return Objects.equals(streamKey(), other.streamKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamKeyResponse").add("StreamKey", streamKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamKey":
            return Optional.ofNullable(clazz.cast(streamKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamKey", STREAM_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamKeyResponse, T> g) {
        return obj -> g.apply((CreateStreamKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamKeyResponse> {
        /**
         * <p>
         * Stream key used to authenticate an RTMPS stream for ingestion.
         * </p>
         * 
         * @param streamKey
         *        Stream key used to authenticate an RTMPS stream for ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamKey(StreamKey streamKey);

        /**
         * <p>
         * Stream key used to authenticate an RTMPS stream for ingestion.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamKey.Builder} avoiding the need to
         * create one manually via {@link StreamKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamKey.Builder#build()} is called immediately and its result
         * is passed to {@link #streamKey(StreamKey)}.
         * 
         * @param streamKey
         *        a consumer that will call methods on {@link StreamKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamKey(StreamKey)
         */
        default Builder streamKey(Consumer<StreamKey.Builder> streamKey) {
            return streamKey(StreamKey.builder().applyMutation(streamKey).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private StreamKey streamKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamKeyResponse model) {
            super(model);
            streamKey(model.streamKey);
        }

        public final StreamKey.Builder getStreamKey() {
            return streamKey != null ? streamKey.toBuilder() : null;
        }

        public final void setStreamKey(StreamKey.BuilderImpl streamKey) {
            this.streamKey = streamKey != null ? streamKey.build() : null;
        }

        @Override
        public final Builder streamKey(StreamKey streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        @Override
        public CreateStreamKeyResponse build() {
            return new CreateStreamKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
