/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamResponse extends IvsResponse implements
        ToCopyableBuilder<GetStreamResponse.Builder, GetStreamResponse> {
    private static final SdkField<Stream> STREAM_FIELD = SdkField.<Stream> builder(MarshallingType.SDK_POJO).memberName("stream")
            .getter(getter(GetStreamResponse::stream)).setter(setter(Builder::stream)).constructor(Stream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Stream stream;

    private GetStreamResponse(BuilderImpl builder) {
        super(builder);
        this.stream = builder.stream;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Stream stream() {
        return stream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamResponse)) {
            return false;
        }
        GetStreamResponse other = (GetStreamResponse) obj;
        return Objects.equals(stream(), other.stream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamResponse").add("Stream", stream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stream":
            return Optional.ofNullable(clazz.cast(stream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stream", STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamResponse, T> g) {
        return obj -> g.apply((GetStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamResponse> {
        /**
         * <p/>
         * 
         * @param stream
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stream(Stream stream);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link Stream.Builder} avoiding the need to
         * create one manually via {@link Stream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stream.Builder#build()} is called immediately and its result is
         * passed to {@link #stream(Stream)}.
         * 
         * @param stream
         *        a consumer that will call methods on {@link Stream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stream(Stream)
         */
        default Builder stream(Consumer<Stream.Builder> stream) {
            return stream(Stream.builder().applyMutation(stream).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private Stream stream;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamResponse model) {
            super(model);
            stream(model.stream);
        }

        public final Stream.Builder getStream() {
            return stream != null ? stream.toBuilder() : null;
        }

        public final void setStream(Stream.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        @Override
        public final Builder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public GetStreamResponse build() {
            return new GetStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
