/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamSessionResponse extends IvsResponse implements
        ToCopyableBuilder<GetStreamSessionResponse.Builder, GetStreamSessionResponse> {
    private static final SdkField<StreamSession> STREAM_SESSION_FIELD = SdkField
            .<StreamSession> builder(MarshallingType.SDK_POJO).memberName("streamSession")
            .getter(getter(GetStreamSessionResponse::streamSession)).setter(setter(Builder::streamSession))
            .constructor(StreamSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StreamSession streamSession;

    private GetStreamSessionResponse(BuilderImpl builder) {
        super(builder);
        this.streamSession = builder.streamSession;
    }

    /**
     * <p>
     * List of stream details.
     * </p>
     * 
     * @return List of stream details.
     */
    public final StreamSession streamSession() {
        return streamSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamSessionResponse)) {
            return false;
        }
        GetStreamSessionResponse other = (GetStreamSessionResponse) obj;
        return Objects.equals(streamSession(), other.streamSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamSessionResponse").add("StreamSession", streamSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamSession":
            return Optional.ofNullable(clazz.cast(streamSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamSession", STREAM_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStreamSessionResponse, T> g) {
        return obj -> g.apply((GetStreamSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamSessionResponse> {
        /**
         * <p>
         * List of stream details.
         * </p>
         * 
         * @param streamSession
         *        List of stream details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSession(StreamSession streamSession);

        /**
         * <p>
         * List of stream details.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamSession.Builder} avoiding the need
         * to create one manually via {@link StreamSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamSession.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSession(StreamSession)}.
         * 
         * @param streamSession
         *        a consumer that will call methods on {@link StreamSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSession(StreamSession)
         */
        default Builder streamSession(Consumer<StreamSession.Builder> streamSession) {
            return streamSession(StreamSession.builder().applyMutation(streamSession).build());
        }
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private StreamSession streamSession;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamSessionResponse model) {
            super(model);
            streamSession(model.streamSession);
        }

        public final StreamSession.Builder getStreamSession() {
            return streamSession != null ? streamSession.toBuilder() : null;
        }

        public final void setStreamSession(StreamSession.BuilderImpl streamSession) {
            this.streamSession = streamSession != null ? streamSession.build() : null;
        }

        @Override
        public final Builder streamSession(StreamSession streamSession) {
            this.streamSession = streamSession;
            return this;
        }

        @Override
        public GetStreamSessionResponse build() {
            return new GetStreamSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
