/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying the ingest configuration set up by the broadcaster, usually in an encoder.
 * </p>
 * <p>
 * <b>Note:</b> IngestConfiguration is deprecated in favor of <a>IngestConfigurations</a> but retained to ensure
 * backward compatibility. If multitrack is not enabled, IngestConfiguration and IngestConfigurations contain the same
 * data, namely information about track0 (the sole track). If multitrack is enabled, IngestConfiguration contains data
 * for only the first track (track0) and IngestConfigurations contains data for all tracks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestConfiguration.Builder, IngestConfiguration> {
    private static final SdkField<AudioConfiguration> AUDIO_FIELD = SdkField
            .<AudioConfiguration> builder(MarshallingType.SDK_POJO).memberName("audio")
            .getter(getter(IngestConfiguration::audio)).setter(setter(Builder::audio)).constructor(AudioConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()).build();

    private static final SdkField<VideoConfiguration> VIDEO_FIELD = SdkField
            .<VideoConfiguration> builder(MarshallingType.SDK_POJO).memberName("video")
            .getter(getter(IngestConfiguration::video)).setter(setter(Builder::video)).constructor(VideoConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioConfiguration audio;

    private final VideoConfiguration video;

    private IngestConfiguration(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
    }

    /**
     * <p>
     * Encoder settings for audio.
     * </p>
     * 
     * @return Encoder settings for audio.
     */
    public final AudioConfiguration audio() {
        return audio;
    }

    /**
     * <p>
     * Encoder settings for video.
     * </p>
     * 
     * @return Encoder settings for video.
     */
    public final VideoConfiguration video() {
        return video;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfiguration)) {
            return false;
        }
        IngestConfiguration other = (IngestConfiguration) obj;
        return Objects.equals(audio(), other.audio()) && Objects.equals(video(), other.video());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestConfiguration").add("Audio", audio()).add("Video", video()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audio", AUDIO_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestConfiguration, T> g) {
        return obj -> g.apply((IngestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestConfiguration> {
        /**
         * <p>
         * Encoder settings for audio.
         * </p>
         * 
         * @param audio
         *        Encoder settings for audio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioConfiguration audio);

        /**
         * <p>
         * Encoder settings for audio.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioConfiguration.Builder} avoiding the
         * need to create one manually via {@link AudioConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #audio(AudioConfiguration)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioConfiguration)
         */
        default Builder audio(Consumer<AudioConfiguration.Builder> audio) {
            return audio(AudioConfiguration.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * Encoder settings for video.
         * </p>
         * 
         * @param video
         *        Encoder settings for video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoConfiguration video);

        /**
         * <p>
         * Encoder settings for video.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoConfiguration.Builder} avoiding the
         * need to create one manually via {@link VideoConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #video(VideoConfiguration)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoConfiguration)
         */
        default Builder video(Consumer<VideoConfiguration.Builder> video) {
            return video(VideoConfiguration.builder().applyMutation(video).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioConfiguration audio;

        private VideoConfiguration video;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfiguration model) {
            audio(model.audio);
            video(model.video);
        }

        public final AudioConfiguration.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public final VideoConfiguration.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoConfiguration video) {
            this.video = video;
            return this;
        }

        @Override
        public IngestConfiguration build() {
            return new IngestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
